/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.server.impl;

import com.excentis.products.byteblower.model.reader.server.CapabilityReader;
import com.excentis.products.byteblower.model.reader.server.MobileDeviceReader;
import com.excentis.products.byteblower.model.reader.server.impl.PhysicalDockableReaderImpl;
import com.excentis.products.byteblower.server.model.DockedByteBlowerPort;
import com.excentis.products.byteblower.server.model.InterfaceLinkStatus;
import com.excentis.products.byteblower.server.model.MeetingPoint;
import com.excentis.products.byteblower.server.model.MobileInterface;
import com.excentis.products.byteblower.server.model.MobileType;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import com.excentis.products.byteblower.server.model.PhysicalMobileDevice;
import com.excentis.products.byteblower.utils.DeviceIPv6InterfaceAddress;
import java.net.Inet4Address;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;

public class MobileDeviceReaderImpl
extends PhysicalDockableReaderImpl<PhysicalMobileDevice>
implements MobileDeviceReader {
    private static final String UNKNOWN_BATTERY_LEVEL_SILENT = "";
    private static final String UNKNOWN_BATTERY_LEVEL_LOUD = "Unknown";

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$server$model$MobileType = MobileDeviceReaderImpl.$SWITCH_TABLE$com$excentis$products$byteblower$server$model$MobileType();
    }

    public MobileDeviceReaderImpl(PhysicalMobileDevice myMobileDevice) {
        super(myMobileDevice);
    }

    @Override
    public MobileType getMobileType() {
        return ((PhysicalMobileDevice)this.getObject()).getMobileType();
    }

    @Override
    public InterfaceLinkStatus getInterfaceLinkStatus() {
        PhysicalMobileDevice obj = (PhysicalMobileDevice)this.getObject();
        return obj.getMobileStatus();
    }

    @Override
    public String getMacAddressString() {
        String invalid = "00:00:00:00:00:00";
        PhysicalMobileDevice obj = (PhysicalMobileDevice)this.getObject();
        for (MobileInterface ifs : obj.getInterfaces()) {
            String addr = ifs.getMacAddress();
            if ("00:00:00:00:00:00".equals(addr)) continue;
            return addr;
        }
        return "00:00:00:00:00:00";
    }

    @Override
    public String getDeviceId() {
        return ((PhysicalMobileDevice)this.getObject()).getId();
    }

    public MeetingPoint getServer() {
        return this.getMeetingPoint();
    }

    @Override
    public MeetingPoint getMeetingPoint() {
        return ((PhysicalMobileDevice)this.getObject()).getMeetingPoint();
    }

    @Override
    public Integer getStatus() {
        MeetingPoint server = this.getMeetingPoint();
        if (server != null) {
            switch (server.getServerLinkStatus().getValue()) {
                case 2: {
                    return this.getInterfaceStatus();
                }
                case 0: {
                    return 1;
                }
            }
        }
        return 2;
    }

    private int getInterfaceStatus() {
        switch (this.getInterfaceLinkStatus().getValue()) {
            case 2: {
                return 3;
            }
            case 0: 
            case 3: 
            case 5: 
            case 7: {
                return 2;
            }
            case 4: 
            case 6: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public EList<DockedByteBlowerPort> getAllDockedPorts() {
        return super.getDockedPorts();
    }

    @Override
    public String getInterfaceString() {
        String returnValue = this.getName();
        if (MobileType.UNKNOWN.equals((Object)this.getMobileType())) {
            return returnValue;
        }
        if (this.isStatusOk()) {
            String batteryLevel = this.getBatteryLevelString(false);
            if (!batteryLevel.isEmpty()) {
                returnValue = String.valueOf(returnValue) + " - " + batteryLevel;
            }
        } else if (this.isLocked()) {
            returnValue = String.valueOf(returnValue) + " - Locked by " + this.getLockOwner();
        }
        return returnValue;
    }

    @Override
    public boolean isLocked() {
        return ((PhysicalMobileDevice)this.getObject()).isIsLocked();
    }

    @Override
    public long getBatteryLevel() {
        return ((PhysicalMobileDevice)this.getObject()).getBatteryLevel();
    }

    @Override
    public String getMobileTypeString() {
        switch (this.getMobileType()) {
            case ANDROID: {
                return "Android";
            }
            case IOS: {
                return "iOS";
            }
            case LINUX: {
                return "Linux";
            }
            case OSX: {
                return "OS X";
            }
            case WINDOWS: {
                return "Windows";
            }
        }
        return UNKNOWN_BATTERY_LEVEL_LOUD;
    }

    @Override
    public String getAppVersion() {
        return ((PhysicalMobileDevice)this.getObject()).getAppVersion();
    }

    @Override
    public String getOsVersion() {
        return ((PhysicalMobileDevice)this.getObject()).getOsVersion();
    }

    @Override
    public EList<PhysicalDockable> getDockables() {
        UniqueEList dockables = new UniqueEList();
        dockables.add((Object)((PhysicalDockable)this.getObject()));
        return dockables;
    }

    @Override
    public int getRemainingCapacity() {
        return this.getDockedPorts().isEmpty() ? 1 : 0;
    }

    @Override
    public String getBatteryLevelString(boolean explicit) {
        String unknown;
        String string = unknown = explicit ? UNKNOWN_BATTERY_LEVEL_LOUD : UNKNOWN_BATTERY_LEVEL_SILENT;
        if (!this.isStatusOk()) {
            return unknown;
        }
        long batteryLevel = this.getBatteryLevel();
        if (0L <= batteryLevel && batteryLevel <= 100L) {
            return String.valueOf(Long.toString(batteryLevel)) + "%";
        }
        return unknown;
    }

    @Override
    public String getDeviceType() {
        return ((PhysicalMobileDevice)this.getObject()).getDeviceType();
    }

    @Override
    public String getLockOwner() {
        return ((PhysicalMobileDevice)this.getObject()).getLockOwner();
    }

    @Override
    public String getIpAddress() {
        String invalidIp = UNKNOWN_BATTERY_LEVEL_SILENT;
        PhysicalMobileDevice obj = (PhysicalMobileDevice)this.getObject();
        for (MobileInterface ifs : obj.getInterfaces()) {
            for (Inet4Address ip : ifs.getIpv4Addresses()) {
                if (ip.isLoopbackAddress() || ip.isAnyLocalAddress()) continue;
                return ip.getHostAddress();
            }
        }
        return invalidIp;
    }

    @Override
    public String getIpv6Address() {
        String invalidIp = UNKNOWN_BATTERY_LEVEL_SILENT;
        PhysicalMobileDevice obj = (PhysicalMobileDevice)this.getObject();
        for (MobileInterface ifs : obj.getInterfaces()) {
            for (DeviceIPv6InterfaceAddress ip : ifs.getIpv6Addresses()) {
                if (ip.isLoopbackAddress() || ip.isAnyLocalAddress()) continue;
                return ip.getHostAddress();
            }
        }
        return invalidIp;
    }

    @Override
    public boolean getLockIsOwner() {
        return ((PhysicalMobileDevice)this.getObject()).isLockIsOwner();
    }

    @Override
    public boolean isTestRunning() {
        InterfaceLinkStatus status = this.getInterfaceLinkStatus();
        return status == InterfaceLinkStatus.TEST_RUNNING || status == InterfaceLinkStatus.OTHER_TEST_RUNNING;
    }

    @Override
    public boolean hasIpv6() {
        return this.hasCapability(CapabilityReader.TYPE.IPv6) && !this.getIpv6Address().isEmpty();
    }

    @Override
    public int getPrefixLength() {
        PhysicalMobileDevice obj = (PhysicalMobileDevice)this.getObject();
        for (MobileInterface ifs : obj.getInterfaces()) {
            for (DeviceIPv6InterfaceAddress ip : ifs.getIpv6Addresses()) {
                if (ip.isLoopbackAddress() || ip.isAnyLocalAddress()) continue;
                return ip.prefixLength();
            }
        }
        return 0;
    }
}

