/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.server.impl;

import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortConfigurationReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.server.AbstractServerReader;
import com.excentis.products.byteblower.model.reader.server.DockedByteBlowerPortReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalConfigurationReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalDockableReader;
import com.excentis.products.byteblower.model.reader.server.impl.EByteBlowerServerObjectReaderImpl;
import com.excentis.products.byteblower.server.model.AbstractServer;
import com.excentis.products.byteblower.server.model.DockedByteBlowerPort;
import com.excentis.products.byteblower.server.model.MeetingPoint;
import com.excentis.products.byteblower.server.model.PhysicalConfiguration;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import com.excentis.products.byteblower.server.model.PhysicalServer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;

public class PhysicalConfigurationReaderImpl
extends EByteBlowerServerObjectReaderImpl<PhysicalConfiguration>
implements PhysicalConfigurationReader {
    private static PhysicalConfigurationReader instance;
    private static PhysicalConfiguration physicalConfiguration;

    public PhysicalConfigurationReaderImpl(PhysicalConfiguration myPhysicalConfiguration) {
        super(myPhysicalConfiguration);
    }

    public static void setPhysicalConfiguration(PhysicalConfiguration configuration) {
        physicalConfiguration = configuration;
    }

    public static boolean isPhysicalConfigurationInitialized() {
        return physicalConfiguration != null;
    }

    public static synchronized PhysicalConfigurationReader getInstance() {
        if (instance == null && physicalConfiguration != null) {
            instance = new PhysicalConfigurationReaderImpl(physicalConfiguration);
        }
        if (instance == null) {
            throw new RuntimeException("Could not create physical config");
        }
        return instance;
    }

    @Override
    public PhysicalDockable getPhysicalDockable(ByteBlowerGuiPortReader portReader) {
        ByteBlowerGuiPortConfigurationReader portConfigReader = portReader.getByteBlowerGuiPortConfigurationReader();
        return this.getPhysicalDockable(portConfigReader);
    }

    @Override
    public PhysicalDockable getPhysicalDockable(ByteBlowerGuiPortConfigurationReader portConfigReader) {
        if (!portConfigReader.isDocked()) {
            return null;
        }
        String serverAddress = portConfigReader.getServerAddress();
        PhysicalDockable dockable = null;
        for (AbstractServerReader<?> reader : this.getAllServerReaders()) {
            String address = reader.getServerAddress();
            if (!address.equals(serverAddress) || (dockable = reader.getPhysicalDockable(portConfigReader)) == null) continue;
            return dockable;
        }
        return null;
    }

    @Override
    public List<AbstractServerReader<?>> getAllServerReaders() {
        ArrayList readers = new ArrayList();
        for (AbstractServer server : this.getAllServers()) {
            readers.add(ReaderFactory.create(server));
        }
        return readers;
    }

    @Override
    public EList<MeetingPoint> getMeetingPoints() {
        return ((PhysicalConfiguration)this.getObject()).getMeetingPoints();
    }

    @Override
    public AbstractServerReader<?> getServerReader(String serverAddress) {
        for (AbstractServerReader<?> reader : this.getAllServerReaders()) {
            if (!reader.getServerAddress().equals(serverAddress)) continue;
            return reader;
        }
        return null;
    }

    @Override
    public List<AbstractServerReader<?>> getUsedServerReaders(ByteBlowerProjectReader byteBlowerProjectReader) {
        List<String> usedAddresses = byteBlowerProjectReader.getUsedServerAddresses();
        return this.getServerReaders(usedAddresses);
    }

    private List<AbstractServerReader<?>> getServerReaders(List<String> usedAddresses) {
        ArrayList readers = new ArrayList();
        for (String address : usedAddresses) {
            AbstractServerReader<?> server = this.getServerReader(address);
            readers.add(server);
        }
        return readers;
    }

    @Override
    public List<String> getServerAddresses() {
        ArrayList<String> serverAddresses = null;
        EList<AbstractServer> servers = this.getAllServers();
        if (servers != null) {
            serverAddresses = new ArrayList<String>(servers.size());
            for (AbstractServer physicalServer : servers) {
                serverAddresses.add(physicalServer.getAddress());
            }
        }
        return serverAddresses;
    }

    @Override
    public DockedByteBlowerPort getDockedPort(ByteBlowerGuiPortReader reader) {
        PhysicalDockableReader<?> dockableReader = this.getPhysicalDockableReader(reader);
        if (dockableReader == null) {
            return null;
        }
        return dockableReader.getDockedPort(reader);
    }

    @Override
    public PhysicalDockableReader<?> getPhysicalDockableReader(ByteBlowerGuiPortReader reader) {
        PhysicalDockable physicalDockable = this.getPhysicalDockable(reader);
        return ReaderFactory.create(physicalDockable);
    }

    @Override
    public EList<DockedByteBlowerPort> getDockedPorts(List<ByteBlowerGuiPortReader> portReaders) {
        UniqueEList dockedPorts = new UniqueEList();
        for (ByteBlowerGuiPortReader portReader : portReaders) {
            if (!portReader.isDocked()) continue;
            DockedByteBlowerPort dockedPort = this.getDockedPort(portReader);
            if (dockedPort == null) {
                System.out.println("PhysicalConfigurationReaderImpl::getDockedPorts : WARNING : inconsistency on port " + portReader.getName() + " : the port is docked, but has no DockedPort !");
                continue;
            }
            dockedPorts.add((Object)dockedPort);
        }
        return dockedPorts;
    }

    @Override
    public List<DockedByteBlowerPortReader> getAllDockedPortReaders() {
        ArrayList<DockedByteBlowerPortReader> allDockedPorts = new ArrayList<DockedByteBlowerPortReader>();
        for (AbstractServerReader<?> reader : this.getAllServerReaders()) {
            allDockedPorts.addAll(reader.getAllDockedPortReaders());
        }
        return allDockedPorts;
    }

    @Override
    public EList<AbstractServer> getAllServers() {
        UniqueEList allServers = new UniqueEList();
        allServers.addAll(this.getPhysicalServers());
        allServers.addAll(this.getMeetingPoints());
        return allServers;
    }

    @Override
    public EList<PhysicalServer> getPhysicalServers() {
        return ((PhysicalConfiguration)this.getObject()).getPhysicalServer();
    }

    @Override
    public EList<AbstractServer> getAbstractServers(String serverAddress) {
        UniqueEList servers = new UniqueEList();
        for (AbstractServer server : this.getAllServers()) {
            if (!server.getAddress().equals(serverAddress)) continue;
            servers.add((Object)server);
        }
        return servers;
    }

    @Override
    public MeetingPoint getMeetingPoint(String serverAddress) {
        EList<MeetingPoint> myMeetingPoints;
        if (serverAddress != null && (myMeetingPoints = this.getMeetingPoints()) != null) {
            for (MeetingPoint aMeetingPoint : myMeetingPoints) {
                if (!serverAddress.equals(aMeetingPoint.getAddress())) continue;
                return aMeetingPoint;
            }
        }
        return null;
    }

    @Override
    public PhysicalServer getPhysicalServer(String serverAddress) {
        EList<PhysicalServer> servers;
        if (serverAddress != null && (servers = this.getPhysicalServers()) != null) {
            for (PhysicalServer server : servers) {
                if (!serverAddress.equals(server.getAddress())) continue;
                return server;
            }
        }
        return null;
    }
}

