/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.server.impl;

import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortConfigurationReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalInterfaceReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalPortReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalServerReader;
import com.excentis.products.byteblower.model.reader.server.impl.PhysicalDockableReaderImpl;
import com.excentis.products.byteblower.model.reader.server.impl.PhysicalInterfaceReaderImpl;
import com.excentis.products.byteblower.server.model.AbstractServer;
import com.excentis.products.byteblower.server.model.DockedByteBlowerPort;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import com.excentis.products.byteblower.server.model.PhysicalInterface;
import com.excentis.products.byteblower.server.model.PhysicalPort;
import com.excentis.products.byteblower.server.model.PortLinkStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;

public class PhysicalPortReaderImpl
extends PhysicalDockableReaderImpl<PhysicalPort>
implements PhysicalPortReader {
    public PhysicalPortReaderImpl(PhysicalPort physicalPort) {
        super(physicalPort);
    }

    @Override
    public Integer getPortId() {
        return ((PhysicalPort)this.getObject()).getId();
    }

    @Override
    public PhysicalDockable getPhysicalDockable(ByteBlowerGuiPortConfigurationReader portConfigReader) {
        Integer configPortId;
        Integer myPortId;
        String configInterfaceId;
        String configServerAddress;
        PhysicalInterfaceReader interfaceReader = this.getPhysicalInterfaceReader();
        PhysicalServerReader serverReader = interfaceReader.getPhysicalServerReader();
        String myServerAddress = serverReader.getServerAddress();
        if (!myServerAddress.equals(configServerAddress = portConfigReader.getServerAddress())) {
            return null;
        }
        String myInterfaceId = interfaceReader.getInterfaceId();
        if (!myInterfaceId.equals(configInterfaceId = portConfigReader.getPhysicalInterfaceId())) {
            return null;
        }
        PhysicalDockable physicalDockable = null;
        if (portConfigReader.isDockedOnPhysicalPort() && (myPortId = this.getPortId()).equals(configPortId = portConfigReader.getPhysicalPortId())) {
            physicalDockable = (PhysicalDockable)this.getObject();
        }
        return physicalDockable;
    }

    @Override
    public PhysicalInterfaceReader getPhysicalInterfaceReader() {
        PhysicalInterface physicalInterface = ((PhysicalPort)this.getObject()).getPhysicalInterface();
        return new PhysicalInterfaceReaderImpl(physicalInterface);
    }

    @Override
    public PortLinkStatus getPortLinkStatus() {
        return ((PhysicalPort)this.getObject()).getPortLinkStatus();
    }

    @Override
    public Integer getStatus() {
        switch (this.getPortLinkStatus().getValue()) {
            case 0: {
                return 2;
            }
            case 1: {
                return 0;
            }
        }
        return 1;
    }

    @Override
    public EList<DockedByteBlowerPort> getAllDockedPorts() {
        return super.getDockedPorts();
    }

    @Override
    public String getInterfaceString() {
        int interfaceNumber = this.getPhysicalInterfaceReader().getInterfaceNumber();
        int portNumber = this.getPortId() + 1;
        return "trunk-" + interfaceNumber + "-" + portNumber;
    }

    @Override
    public AbstractServer getServer() {
        return this.getPhysicalInterfaceReader().getServer();
    }

    @Override
    public EList<PhysicalDockable> getDockables() {
        UniqueEList dockables = new UniqueEList();
        dockables.add((Object)((PhysicalDockable)this.getObject()));
        return dockables;
    }
}

