/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DataRateUnit implements Enumerator
{
    BPS(0, "bps", "bps"),
    KBPS(1, "kbps", "kbps"),
    MBPS(2, "Mbps", "Mbps"),
    GBPS(3, "Gbps", "Gbps"),
    BYTESPS(4, "Bytesps", "Bytesps"),
    KBYTESPS(5, "KBytesps", "KBytesps"),
    MBYTESPS(6, "MBytesps", "MBytesps"),
    GBYTESPS(7, "GBytesps", "GBytesps");

    public static final String copyright = "Copyright 2005 - 2023 Excentis nv";
    public static final int BPS_VALUE = 0;
    public static final int KBPS_VALUE = 1;
    public static final int MBPS_VALUE = 2;
    public static final int GBPS_VALUE = 3;
    public static final int BYTESPS_VALUE = 4;
    public static final int KBYTESPS_VALUE = 5;
    public static final int MBYTESPS_VALUE = 6;
    public static final int GBYTESPS_VALUE = 7;
    private static final DataRateUnit[] VALUES_ARRAY;
    public static final List<DataRateUnit> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DataRateUnit[]{BPS, KBPS, MBPS, GBPS, BYTESPS, KBYTESPS, MBYTESPS, GBYTESPS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DataRateUnit get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataRateUnit result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataRateUnit getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataRateUnit result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataRateUnit get(int value) {
        switch (value) {
            case 0: {
                return BPS;
            }
            case 1: {
                return KBPS;
            }
            case 2: {
                return MBPS;
            }
            case 3: {
                return GBPS;
            }
            case 4: {
                return BYTESPS;
            }
            case 5: {
                return KBYTESPS;
            }
            case 6: {
                return MBYTESPS;
            }
            case 7: {
                return GBYTESPS;
            }
        }
        return null;
    }

    private DataRateUnit(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

