/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum HTTPMethod implements Enumerator
{
    AUTOMATIC(0, "Automatic", "Auto"),
    PUT(1, "PUT", "PUT"),
    GET(2, "GET", "GET");

    public static final String copyright = "Copyright 2005 - 2023 Excentis nv";
    public static final int AUTOMATIC_VALUE = 0;
    public static final int PUT_VALUE = 1;
    public static final int GET_VALUE = 2;
    private static final HTTPMethod[] VALUES_ARRAY;
    public static final List<HTTPMethod> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new HTTPMethod[]{AUTOMATIC, PUT, GET};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static HTTPMethod get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HTTPMethod result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HTTPMethod getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HTTPMethod result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HTTPMethod get(int value) {
        switch (value) {
            case 0: {
                return AUTOMATIC;
            }
            case 1: {
                return PUT;
            }
            case 2: {
                return GET;
            }
        }
        return null;
    }

    private HTTPMethod(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

