/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MldVersion implements Enumerator
{
    ML_DV1_LITERAL(1, "MLDv1", "MLDv1"),
    ML_DV2_LITERAL(2, "MLDv2", "MLDv2");

    public static final String copyright = "Copyright 2005 - 2023 Excentis nv";
    public static final int ML_DV1 = 1;
    public static final int ML_DV2 = 2;
    private static final MldVersion[] VALUES_ARRAY;
    public static final List<MldVersion> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MldVersion[]{ML_DV1_LITERAL, ML_DV2_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MldVersion get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MldVersion result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MldVersion getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MldVersion result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MldVersion get(int value) {
        switch (value) {
            case 1: {
                return ML_DV1_LITERAL;
            }
            case 2: {
                return ML_DV2_LITERAL;
            }
        }
        return null;
    }

    private MldVersion(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

