/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.object.control;

import com.excentis.products.byteblower.command.PessimisticStrictCompoundCommand;
import com.excentis.products.byteblower.object.control.ByteBlowerCompoundCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.StrictCompoundCommand;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.RemoveCommand;

public class CompoundCommandController {
    private final CompoundCommand compoundCommand;

    public CompoundCommand getCompoundCommand() {
        return this.compoundCommand;
    }

    public CompoundCommandController(CompoundCommand myCompoundCommand) {
        this.compoundCommand = myCompoundCommand;
    }

    private CompoundCommandController() {
        this(new ByteBlowerCompoundCommand());
    }

    public static final CompoundCommandController createInstance() {
        return new CompoundCommandController();
    }

    public static final CompoundCommandController createStrictInstance(boolean pessimistic) {
        return new CompoundCommandController((CompoundCommand)(pessimistic ? new PessimisticStrictCompoundCommand() : new StrictCompoundCommand()));
    }

    public final void appendCommand(Command command) {
        if (command != null) {
            if (command instanceof CompoundCommand && !(command instanceof DeleteCommand) && ((CompoundCommand)command).isEmpty()) {
                return;
            }
            this.compoundCommand.append(command);
        }
    }

    public void appendCommand(CompoundCommandController compoundCommandController) {
        if (compoundCommandController.compoundCommand != null) {
            this.appendCommand((Command)compoundCommandController.compoundCommand);
        }
    }

    private void removeAllAddCommands(CompoundCommand compound, EStructuralFeature eStructuralFeature, Collection<?> eObjects) {
        List commands = compound.getCommandList();
        ArrayList<Command> addCommands = new ArrayList<Command>();
        for (Command command : commands) {
            if (command instanceof AddCommand && ((AddCommand)command).getFeature() == eStructuralFeature) {
                addCommands.add(command);
                continue;
            }
            if (!(command instanceof CompoundCommand)) continue;
            this.removeAllAddCommands((CompoundCommand)command, eStructuralFeature, eObjects);
        }
        if (!addCommands.isEmpty()) {
            commands.removeAll(addCommands);
        }
    }

    private void removeAllRemoveCommands(CompoundCommand compound, EStructuralFeature eStructuralFeature, Collection<?> eObjects) {
        List commands = compound.getCommandList();
        ArrayList<Command> removeCommands = new ArrayList<Command>();
        for (Command command : commands) {
            if (command instanceof RemoveCommand && ((RemoveCommand)command).getFeature() == eStructuralFeature) {
                removeCommands.add(command);
                continue;
            }
            if (!(command instanceof CompoundCommand)) continue;
            this.removeAllRemoveCommands((CompoundCommand)command, eStructuralFeature, eObjects);
        }
        if (!removeCommands.isEmpty()) {
            commands.removeAll(removeCommands);
        }
    }

    public void removeAllAddCommands(EStructuralFeature eStructuralFeature, Collection<?> eObjects) {
        this.removeAllAddCommands(this.compoundCommand, eStructuralFeature, eObjects);
    }

    public void removeAllRemoveCommands(EStructuralFeature eStructuralFeature, Collection<?> eObjects) {
        this.removeAllRemoveCommands(this.compoundCommand, eStructuralFeature, eObjects);
    }

    public Command unwrap() {
        if (this.compoundCommand != null && !this.compoundCommand.isEmpty()) {
            return this.compoundCommand.unwrap();
        }
        return new IdentityCommand();
    }

    public boolean isEmpty() {
        return this.compoundCommand == null || this.compoundCommand.isEmpty();
    }

    public boolean canExecute() {
        return this.compoundCommand != null && this.compoundCommand.canExecute();
    }

    public void execute() {
        if (this.compoundCommand != null && !this.compoundCommand.isEmpty() && this.compoundCommand.canExecute()) {
            this.compoundCommand.execute();
        }
    }

    public void redo() {
        if (this.compoundCommand != null) {
            this.compoundCommand.redo();
        }
    }

    public void undo() {
        if (this.compoundCommand != null) {
            this.compoundCommand.undo();
        }
    }

    public void dispose() {
        if (this.compoundCommand != null) {
            this.compoundCommand.dispose();
        }
    }

    public Collection<?> getAffectedObjects() {
        if (this.compoundCommand != null) {
            return this.compoundCommand.getAffectedObjects();
        }
        return Collections.EMPTY_LIST;
    }

    public Collection<?> getResult() {
        if (this.compoundCommand != null) {
            return this.compoundCommand.getResult();
        }
        return Collections.EMPTY_LIST;
    }
}

