/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.project;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.model.Batch;
import com.excentis.products.byteblower.model.BatchAction;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelFactory;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.DataRateUnit;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.FrameBlastingBenchmark;
import com.excentis.products.byteblower.model.Measurement;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.TCPCongestionAvoidanceAlgorithm;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.TimedStartType;
import com.excentis.products.byteblower.model.Vlan;
import com.excentis.products.byteblower.model.VlanStack;
import com.excentis.products.byteblower.model.control.BatchActionBlockController;
import com.excentis.products.byteblower.model.control.BatchActionController;
import com.excentis.products.byteblower.model.control.BatchController;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortController;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.DhcpController;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.FlowMeasurementController;
import com.excentis.products.byteblower.model.control.Ipv4ConfigurationController;
import com.excentis.products.byteblower.model.control.Ipv6ConfigurationController;
import com.excentis.products.byteblower.model.control.TcpFlowController;
import com.excentis.products.byteblower.model.control.VlanController;
import com.excentis.products.byteblower.model.control.VlanStackController;
import com.excentis.products.byteblower.model.reader.BatchReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.FrameBlastingBenchmarkReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.ByteBlowerProjectReaderImpl;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.project.ByteBlowerXmlHelper;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionDuration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.osgi.framework.Version;

public class ByteBlowerResource
extends XMIResourceImpl {
    private static final ByteblowerguimodelPackage byteblowerGuiPackage = ByteblowerguimodelPackage.eINSTANCE;
    private static final ByteblowerguimodelFactory byteblowerguimodelFactory = byteblowerGuiPackage.getByteblowerguimodelFactory();

    ByteBlowerResource(URI uri) {
        this(uri.toFileString());
    }

    protected XMLHelper createXMLHelper() {
        return new ByteBlowerXmlHelper((XMLResource)this);
    }

    private ByteBlowerResource(String path) {
        super(URI.createFileURI((String)path));
    }

    public void setByteBlowerProject(ByteBlowerProject byteBlowerProject) {
        if (!this.getContents().isEmpty()) {
            throw new IllegalStateException("ByteBlower resource already has content when setting project");
        }
        this.getContents().add((Object)byteBlowerProject);
    }

    void updateProject() {
        String currentModelVersion;
        ByteBlowerProject project = this.getByteBlowerProject();
        if (project == null) {
            throw new XMLOpenException();
        }
        String modelVersion = project.getModelVersion();
        int comparison = ByteBlowerResource.compareVersion(modelVersion, currentModelVersion = "2.22.6");
        if (comparison < 0) {
            System.out.println("Opened an old project. Version = " + modelVersion + ". Upgrading to " + currentModelVersion);
            CompatibilityHelper.applyModelCompatibility(project);
            project.setModelVersion(currentModelVersion);
        }
    }

    private static int compareVersion(String version1, String version2) {
        return new Version(version1).compareTo(new Version(version2));
    }

    private static boolean isVersion1DotX(String version) {
        String[] numbers = version.split("\\.");
        return numbers[0].equals("1") && !numbers[1].equals("99");
    }

    public void setResourceFileName(String fileName) {
        URI newUri = URI.createFileURI((String)fileName);
        this.setURI(newUri);
    }

    public ByteBlowerProject getByteBlowerProject() {
        ByteBlowerProject project = null;
        EList contents = this.getContents();
        if (!contents.isEmpty()) {
            Object rootObject = contents.get(0);
            if (rootObject instanceof ByteBlowerProject) {
                project = (ByteBlowerProject)rootObject;
            } else {
                System.out.print("Unsupported root object : " + rootObject.toString());
            }
        }
        return project;
    }

    final ByteBlowerProject createInitialModel(String projectName, String authorName) {
        EClass eClass = (EClass)byteblowerGuiPackage.getEClassifier("ByteBlowerProject");
        EObject rootObject = byteblowerguimodelFactory.create(eClass);
        ByteBlowerProject project = (ByteBlowerProject)rootObject;
        project.setName(projectName);
        project.setAuthor(authorName);
        project.setModelVersion("2.22.6");
        project.setThroughputType(ThroughputType.get((int)ByteBlowerPreferences.getThroughputType()));
        project.setDhcpTimeout(new HighResolutionCalendar(ByteBlowerPreferences.getDhcpTimeout()));
        project.setDhcpRetries(ByteBlowerPreferences.getDhcpRetries());
        project.setWarningLossLevel(ByteBlowerPreferences.getWarningLossLevel());
        project.setErrorLossLevel(ByteBlowerPreferences.getErrorLossLevel());
        project.setReportOutputToDynamicHtml(ByteBlowerPreferences.getOutputToDynamicHtml());
        project.setReportOutputToHtml(ByteBlowerPreferences.getOutputToHtml());
        project.setReportOutputToExcel(ByteBlowerPreferences.getOutputToExcel());
        project.setReportOutputToCsv(ByteBlowerPreferences.getOutputToCsv());
        project.setReportOutputToPdf(ByteBlowerPreferences.getOutputToPdf());
        project.setReportOutputToJson(ByteBlowerPreferences.getOutputToJson());
        project.setReportProjectBackup(ByteBlowerPreferences.getOutputProjectBackup());
        project.setThroughputUnit(DataRateUnit.get((int)ByteBlowerPreferences.getThroughputUnit()));
        project.setNumberOfDecimals(ByteBlowerPreferences.getNumberOfDecimals());
        project.setLatencyUnit(ByteBlowerPreferences.getLatencyUnit());
        project.setNumberOfLatencyDecimals(ByteBlowerPreferences.getNumberOfLatencyDecimals());
        project.setLatencyRangeStart(new HighResolutionCalendar(ByteBlowerPreferences.getLatencyRangeStart()));
        project.setLatencyRangeEnd(new HighResolutionCalendar(ByteBlowerPreferences.getLatencyRangeEnd()));
        project.setScenarioIdenticalFramesWarning(ByteBlowerPreferences.getIdenticalFramesWarning());
        project.setScenarioPauseAfterDhcp(ByteBlowerPreferences.getPauseAfterDhcp());
        project.setScenarioIgnoreInitializationErrors(ByteBlowerPreferences.getIgnoreInitializationErrors());
        project.setScenarioEnableScoutingFrames(ByteBlowerPreferences.getEnableScoutingFrames());
        project.setScenarioAutomaticTcpRestart(ByteBlowerPreferences.getEnableAutomaticTcpRestart());
        project.setScenarioWaitTimeAfterScenario(new HighResolutionCalendar(ByteBlowerPreferences.getWaitTimeAfterScenario()));
        project.setResultsOverTimeEnabled(ByteBlowerPreferences.getDefaultResultsOverTimeEnabled());
        project.setScenarioHeartbeatInterval(ByteBlowerPreferences.getDefaultScenarioHeartbeatInterval());
        return project;
    }

    private static class CompatibilityHelper {
        private CompatibilityHelper() {
        }

        public static void applyModelCompatibility(ByteBlowerProject project) {
            CompatibilityHelper.updateDhcpIfNecessary(project);
            CompatibilityHelper.updateMtuIfNecessary(project);
            CompatibilityHelper.updateTcpCaaConfigIfNecessary(project);
            CompatibilityHelper.updateBatchIfNecessary(project);
            CompatibilityHelper.updateVlanStackIfNecessary(project);
            CompatibilityHelper.updateItemNamesIfNecessary(project);
            CompatibilityHelper.updateRFC2544IfNecessary(project);
        }

        private static void updateRFC2544IfNecessary(ByteBlowerProject project) {
            String modelVersion = project.getModelVersion();
            if (ByteBlowerResource.compareVersion(modelVersion, "2.9.0") < 0) {
                CompoundCommandController compound = CompoundCommandController.createInstance();
                for (Scenario scenario : project.getScenario()) {
                    for (Measurement measure : scenario.getMeasurements()) {
                        Flow flow;
                        FlowMeasurement flowMeasure;
                        if (!(measure instanceof FlowMeasurement) || (flowMeasure = (FlowMeasurement)measure).getFlow() == null || !((flow = flowMeasure.getFlow()).getFlowTemplate() instanceof FrameBlastingBenchmark)) continue;
                        FlowMeasurementController measurementCtrl = new FlowMeasurementController(flowMeasure);
                        FrameBlastingBenchmark bench = (FrameBlastingBenchmark)flow.getFlowTemplate();
                        int countSizes = bench.getFrames().size();
                        HighResolutionDuration totalDuration = FrameBlastingBenchmarkReader.getEstimatedDuration((HighResolutionCalendar)measurementCtrl.getDuration(), (int)countSizes);
                        compound.appendCommand(measurementCtrl.setDuration((HighResolutionCalendar)totalDuration));
                    }
                }
                compound.execute();
            }
        }

        private static void updateBatchIfNecessary(ByteBlowerProject project) {
            String modelVersion = project.getModelVersion();
            if (ByteBlowerResource.isVersion1DotX(modelVersion)) {
                CompoundCommandController compound = CompoundCommandController.createInstance();
                ByteBlowerProjectController projectController = new ByteBlowerProjectController(project);
                for (BatchController batchController : projectController.getBatchControllers()) {
                    BatchReader batchReader = ReaderFactory.create((Batch)((Batch)batchController.getObject()));
                    BatchActionBlockController firstBabController = null;
                    for (BatchActionBlockController babController : batchController.getBatchActionBlockControllers()) {
                        if (firstBabController == null) {
                            firstBabController = babController;
                            if (!batchReader.isAbsoluteTimed()) continue;
                            compound.appendCommand(batchController.createSetStartTypeCommand(TimedStartType.RELATIVE));
                            if (firstBabController.getBatchActions().isEmpty()) continue;
                            BatchActionController firstBaController = ControllerFactory.create((BatchAction)((BatchAction)firstBabController.getBatchActions().get(0)));
                            compound.appendCommand(firstBaController.setStartTime(new HighResolutionCalendar()));
                            continue;
                        }
                        boolean first = true;
                        for (BatchAction ba : babController.getBatchActions()) {
                            if (first) {
                                BatchActionController firstCopiedBaController = ControllerFactory.create((BatchAction)ba);
                                compound.appendCommand(firstCopiedBaController.setStartTime(new HighResolutionCalendar()));
                                first = false;
                            }
                            compound.appendCommand(firstBabController.createAddBatchActionCommand(ba));
                        }
                        compound.appendCommand(EByteBlowerObjectController.createDeleteCommand((Object)babController.getObject()));
                    }
                }
                compound.execute();
            }
        }

        private static void updateTcpCaaConfigIfNecessary(ByteBlowerProject project) {
            String modelVersion = project.getModelVersion();
            if (ByteBlowerResource.isVersion1DotX(modelVersion)) {
                CompoundCommandController compound = CompoundCommandController.createInstance();
                ByteBlowerProjectController projectController = new ByteBlowerProjectController(project);
                for (TcpFlowController tcpFlowController : projectController.getTcpFlowControllers()) {
                    if (((TcpFlow)tcpFlowController.getObject()).getTCPCongestionAvoidanceAlgorithm() != TCPCongestionAvoidanceAlgorithm.SERVER_DEFAULT) continue;
                    compound.appendCommand(tcpFlowController.setTCPCongestionAvoidanceAlgorithm(TCPCongestionAvoidanceAlgorithm.SACK));
                }
                compound.execute();
            }
        }

        private static void updateMtuIfNecessary(ByteBlowerProject project) {
            String modelVersion = project.getModelVersion();
            if (ByteBlowerResource.isVersion1DotX(modelVersion)) {
                CompoundCommandController compound = CompoundCommandController.createInstance();
                ByteBlowerProjectController projectController = new ByteBlowerProjectController(project);
                for (ByteBlowerGuiPortController portController : projectController.getByteBlowerGuiPortControllers()) {
                    if (!((ByteBlowerGuiPort)portController.getObject()).isSetMtu()) continue;
                    compound.appendCommand(portController.setMtu(Long.valueOf(portController.getMTU() - 14L)).getCommand());
                }
                compound.execute();
            }
        }

        private static void updateDhcpIfNecessary(ByteBlowerProject project) {
            String modelVersion = project.getModelVersion();
            if (ByteBlowerResource.compareVersion(modelVersion, "1.8.16") < 0) {
                CompatibilityHelper.updateDhcp(project);
            }
        }

        private static void updateDhcp(ByteBlowerProject openedProject) {
            boolean usesOldDhcpv4 = CompatibilityHelper.projectUsesOldDhcpv4Ports(openedProject);
            boolean usesOldDhcpv6 = CompatibilityHelper.projectUsesOldDhcpv6Ports(openedProject);
            if (!usesOldDhcpv4 && !usesOldDhcpv6) {
                return;
            }
            CompoundCommandController compound = CompoundCommandController.createInstance();
            ByteBlowerProjectController projectController = new ByteBlowerProjectController(openedProject);
            ByteBlowerProjectController.CommandWithDhcpListReference commandWithRef = projectController.addDhcp(false);
            compound.appendCommand(commandWithRef.getCommand());
            DhcpController newDhcpController = (DhcpController)((List)commandWithRef.getCommandReference()).get(0);
            Dhcp newDhcp = (Dhcp)newDhcpController.getObject();
            for (ByteBlowerGuiPortController portController : projectController.getByteBlowerGuiPortControllers()) {
                if (portController.usesOldDhcpv4()) {
                    Ipv4ConfigurationController ipv4ConfigurationController = portController.getIpv4ConfigurationController();
                    compound.appendCommand(ipv4ConfigurationController.setDhcp(newDhcp).getCommand());
                }
                if (!portController.usesOldDhcpv6()) continue;
                Ipv6ConfigurationController ipv6ConfigurationController = portController.getIpv6ConfigurationController();
                compound.appendCommand(ipv6ConfigurationController.setDhcp(newDhcp).getCommand());
            }
            compound.execute();
        }

        private static boolean projectUsesOldDhcpv4Ports(ByteBlowerProject openedProject) {
            ByteBlowerProjectReaderImpl projectReader = new ByteBlowerProjectReaderImpl(openedProject);
            for (ByteBlowerGuiPortReader portReader : projectReader.getByteBlowerGuiPortReaders()) {
                if (!portReader.usesOldDhcpv4()) continue;
                return true;
            }
            return false;
        }

        private static boolean projectUsesOldDhcpv6Ports(ByteBlowerProject openedProject) {
            ByteBlowerProjectController projectController = new ByteBlowerProjectController(openedProject);
            for (ByteBlowerGuiPortController portController : projectController.getByteBlowerGuiPortControllers()) {
                if (!portController.usesOldDhcpv6()) continue;
                return true;
            }
            return false;
        }

        private static void updateItemNamesIfNecessary(ByteBlowerProject project) {
            String modelVersion = project.getModelVersion();
            if (ByteBlowerResource.compareVersion(modelVersion, "2.7.2") < 0) {
                CompatibilityHelper.updateItemNames(project);
            }
        }

        private static void updateItemNames(ByteBlowerProject project) {
            CompoundCommandController compound = CompoundCommandController.createInstance();
            TreeIterator eAllContents = project.eAllContents();
            while (eAllContents.hasNext()) {
                EObject next = (EObject)eAllContents.next();
                if (!(next instanceof EByteBlowerObject)) continue;
                EByteBlowerObject object = (EByteBlowerObject)next;
                compound.appendCommand(CompatibilityHelper.updateItemName(object));
            }
            compound.execute();
        }

        private static Command updateItemName(EByteBlowerObject object) {
            String name = object.getName();
            if (name != null && !Pattern.matches("[a-zA-Z0-9. \\t<|>_-]*", name)) {
                String newName = name;
                int index = 0;
                while (index < name.length()) {
                    String ch = String.valueOf(name.charAt(index));
                    if (!Pattern.matches("[a-zA-Z0-9. \\t<|>_-]*", ch)) {
                        newName = newName.replace(ch, "_");
                    }
                    ++index;
                }
                EByteBlowerObjectController controller = ControllerFactory.create((EByteBlowerObject)object);
                return controller.setName(newName);
            }
            return null;
        }

        private static void updateVlanStackIfNecessary(ByteBlowerProject project) {
            String modelVersion = project.getModelVersion();
            if (ByteBlowerResource.compareVersion(modelVersion, "2.3.0") < 0) {
                CompatibilityHelper.updateVlanStack(project);
            } else if (ByteBlowerResource.compareVersion(modelVersion, "2.20.2") < 0) {
                CompatibilityHelper.updateVlanProtocolId(project);
            }
        }

        private static void updateVlanStack(ByteBlowerProject openedProject) {
            if (!CompatibilityHelper.projectUsesDeprecatedVlans(openedProject)) {
                return;
            }
            CompoundCommandController compound = CompoundCommandController.createInstance();
            ByteBlowerProjectController projectController = new ByteBlowerProjectController(openedProject);
            HashMap<Vlan, VlanStack> newStacks = new HashMap<Vlan, VlanStack>();
            for (Vlan vlan : projectController.getVlans()) {
                ByteBlowerProjectController.CommandWithVlanStackListReference stackList = projectController.addEmptyVlanStack();
                VlanStackController newStackController = (VlanStackController)((List)stackList.getCommandReference()).get(0);
                VlanStack newVlanStack = (VlanStack)newStackController.getObject();
                compound.appendCommand(stackList.getCommand());
                newVlanStack.setName(vlan.getName());
                compound.appendCommand(newStackController.createAddVlanCommand(vlan));
                newStacks.put(vlan, newVlanStack);
            }
            for (ByteBlowerGuiPortController portController : projectController.getByteBlowerGuiPortControllers()) {
                if (!portController.usesDeprecatedVlan()) continue;
                Vlan origVlan = portController.getDeprecatedVlan();
                VlanStack newVlanStack = (VlanStack)newStacks.get(origVlan);
                compound.appendCommand(portController.setVlanStackCommand((Object)newVlanStack));
                ByteBlowerGuiPort port = (ByteBlowerGuiPort)portController.getObject();
                EList deprecatedVlans = port.getVlanStack();
                compound.appendCommand(EByteBlowerObjectController.createDeleteCommand((Collection)deprecatedVlans));
            }
            compound.execute();
        }

        private static void updateVlanProtocolId(ByteBlowerProject openedProject) {
            CompoundCommandController compound = CompoundCommandController.createInstance();
            ByteBlowerProjectController projectController = new ByteBlowerProjectController(openedProject);
            for (VlanStack stack : projectController.getVlanStacks()) {
                int newProtocolId = 34984;
                EList vlans = stack.getVlans();
                for (Vlan vlan : vlans) {
                    int protocolId = vlan.getProtocolId();
                    if (protocolId != 0) continue;
                    if (vlans.indexOf((Object)vlan) == vlans.size() - 1) {
                        newProtocolId = 33024;
                    }
                    VlanController vlanController = (VlanController)ControllerFactory.create((EByteBlowerObject)vlan);
                    compound.appendCommand(vlanController.setProtocolId(newProtocolId));
                }
            }
            compound.execute();
        }

        private static boolean projectUsesDeprecatedVlans(ByteBlowerProject openedProject) {
            ByteBlowerProjectReaderImpl projectReader = new ByteBlowerProjectReaderImpl(openedProject);
            for (ByteBlowerGuiPortReader portReader : projectReader.getByteBlowerGuiPortReaders()) {
                if (!portReader.usesDeprecatedVlan()) continue;
                return true;
            }
            return false;
        }
    }

    private static class XMLOpenException
    extends RuntimeException {
        private static final long serialVersionUID = -1011500004615511812L;

        public XMLOpenException() {
            super("The GUI does not recognize this file. Did you open an old project?");
        }
    }
}

