/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public class UploadConfig {
    protected static final String DEFAULT_UPLOAD = "https://cloud.excentis.com/";
    private static final String DEFAULT_APIKEY = "";
    public static final String ENV_APIKEY = "EXCENTIS_APIKEY";
    private static final String ENV_CLOUD_LOCATION = "EXCENTIS_CLOUD";
    public String apiKey;
    public String uploadLocation;
    public boolean shouldUpload;

    private static String envApiKey() {
        return System.getenv().getOrDefault(ENV_APIKEY, DEFAULT_APIKEY);
    }

    public static boolean hasEnvConfig() {
        Map<String, String> env = System.getenv();
        return env.containsKey(ENV_APIKEY) || env.containsKey(ENV_CLOUD_LOCATION);
    }

    private static String envUpload() {
        return System.getenv().getOrDefault(ENV_CLOUD_LOCATION, DEFAULT_UPLOAD);
    }

    public UploadConfig(String key, String uploadLocation) {
        this.apiKey = key;
        this.uploadLocation = uploadLocation;
        this.shouldUpload = true;
    }

    public UploadConfig(String key) {
        this.apiKey = key;
        this.uploadLocation = UploadConfig.envUpload();
        this.shouldUpload = true;
    }

    public UploadConfig() {
        this.apiKey = UploadConfig.envApiKey();
        this.uploadLocation = UploadConfig.envUpload();
        this.shouldUpload = UploadConfig.hasEnvConfig();
    }

    public boolean setKeyFile(String apiKeyFile) throws IOException {
        block12: {
            int tooLarge = 65536;
            char[] data = new char[tooLarge];
            Path keyFile = Paths.get(apiKeyFile, new String[0]);
            if (Files.isReadable(keyFile)) {
                try {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (BufferedReader reader = Files.newBufferedReader(keyFile);){
                        int finalSize = reader.read(data);
                        this.setKeyString(new String(data, 0, finalSize));
                        break block12;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException ex) {
                    throw new IOException("Can't read file containing API key", ex);
                }
            }
            throw new IOException("Can't read file containing API key");
        }
        return true;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public URL getUploadLocation() {
        try {
            return new URL(this.uploadLocation);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    private boolean validateUrl(String loc) {
        try {
            new URL(loc);
            return true;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    public boolean setUploadLocation(String loc) {
        boolean isGoodUrl = this.validateUrl(loc);
        if (isGoodUrl) {
            this.uploadLocation = loc;
            this.shouldUpload = true;
        }
        return isGoodUrl;
    }

    private static String sanitizeKey(String orig) {
        String properCharset = new String(orig.getBytes(StandardCharsets.US_ASCII));
        return properCharset.trim();
    }

    public void setKeyString(String newKey) {
        this.apiKey = UploadConfig.sanitizeKey(newKey);
        this.shouldUpload = true;
    }
}

