/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.dataprovider.data;

import com.excentis.products.byteblower.datalibs.DatabaseConfiguration;
import com.excentis.products.byteblower.datalibs.DatabaseGenerator;
import com.excentis.products.byteblower.datalibs.DatabaseJPAConnectorImpl;
import com.excentis.products.byteblower.datalibs.DatabaseModifier;
import com.excentis.products.byteblower.results.dataprovider.data.MetaDataPersistenceError;
import com.excentis.products.byteblower.results.dataprovider.data.MetaDatabaseUpdater;
import com.excentis.products.byteblower.results.dataprovider.data.MetaTagManager;
import com.excentis.products.byteblower.results.dataprovider.data.entities.Tag;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.dataprovider.data.entities.core.BaseEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Root;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.eclipse.persistence.jpa.JpaQuery;

public class MetaDataPersistenceController {
    private static final Logger LOGGER = Logger.getLogger(MetaDataPersistenceController.class.getName());
    private static final String PERSISTENCE_UNIT = "com.excentis.products.byteblower.results.metadata";
    private static DatabaseConfiguration DEFAULTTCONFIG = DatabaseConfiguration.createH2((String)"byteblower", (String)"excentis", (String)"~/byteblower/workspace_v2/TestData/", (String)"byteblower_results_metadata");
    private static MetaDataPersistenceController instance = null;
    private static DatabaseConfiguration config;
    private EntityManagerFactory entityManagerFactory;
    private EntityManager entityManager;

    private static synchronized MetaDataPersistenceController getInstance(DatabaseConfiguration config) {
        if (instance == null) {
            LOGGER.log(Level.INFO, "creating Metadatabase");
            DatabaseGenerator generator = new DatabaseGenerator(config);
            try {
                URL platformFileURL = new URL("platform:/plugin/com.excentis.products.byteblower.results.dataprovider.plugin/dbgenerator/script.sql");
                String sqlScript = IOUtils.toString((InputStream)platformFileURL.openStream(), (String)"UTF-8");
                generator.performDatabaseGeneration(sqlScript, (DatabaseModifier)new MetaDatabaseUpdater());
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Not able to generate DB", e);
            }
            MetaDataPersistenceController.config = config;
            instance = new MetaDataPersistenceController();
        }
        return instance;
    }

    public static MetaDataPersistenceController getInstance() {
        return MetaDataPersistenceController.getInstance(DEFAULTTCONFIG);
    }

    private MetaDataPersistenceController() {
        this.forceInitialize();
    }

    <T extends BaseEntity> T getEntity(Class<T> idEntityType, Long id) {
        String className = idEntityType.getSimpleName();
        LOGGER.fine("PersistenceController (results_metadata): getEntity called for idEntity " + className + " with id " + id);
        EntityManager em = this.getEntityManager();
        try {
            return (T)((BaseEntity)em.find(idEntityType, (Object)id));
        }
        catch (PersistenceException ex) {
            throw new MetaDataPersistenceError("Failed to retrieve idEntity " + className + " with id " + id + ":\n" + ex.getMessage(), ex);
        }
    }

    <T> List<T> getEntities(Class<T> entityType) throws MetaDataPersistenceError {
        String className = entityType.getSimpleName();
        LOGGER.fine("PersistenceController (results_metadata): getEntities called for entity " + className);
        CriteriaBuilder qb = this.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(entityType);
        Root entities = query.from(entityType);
        try {
            return this.getEntities(query);
        }
        catch (MetaDataPersistenceError ex) {
            throw new MetaDataPersistenceError("Failed to retrieve all entities " + className, ex);
        }
    }

    private CriteriaBuilder getCriteriaBuilder() {
        return this.getEntityManager().getCriteriaBuilder();
    }

    private <T> List<T> getEntities(CriteriaQuery<T> criteriaQuery) throws MetaDataPersistenceError {
        TypedQuery typedQuery = this.getEntityManager().createQuery(criteriaQuery);
        String className = criteriaQuery.getResultType().getSimpleName();
        String queryString = ((JpaQuery)typedQuery.unwrap(JpaQuery.class)).getDatabaseQuery().getJPQLString();
        LOGGER.fine("PersistenceController (results_metadata): getEntities called for idEntity " + className + " using query:\n" + queryString);
        List entitiesFromDb = null;
        try {
            entitiesFromDb = typedQuery.getResultList();
        }
        catch (PersistenceException ex) {
            throw new MetaDataPersistenceError("Failed to retrieve idEntities " + className + " with query\n" + queryString + ":\n" + ex.getMessage(), ex);
        }
        return entitiesFromDb;
    }

    void deleteIdEntity(BaseEntity idEntity) throws MetaDataPersistenceError {
        String className = idEntity.getClass().getSimpleName();
        LOGGER.fine("PersistenceController (results_metadata): deleteIdEntity called for idEntity " + className + " with id " + idEntity.getId());
        EntityManager em = this.getEntityManager();
        try {
            em.getTransaction().begin();
            em.remove((Object)idEntity);
            em.getTransaction().commit();
        }
        catch (Exception ex) {
            boolean rollBackFailed = false;
            try {
                em.getTransaction().rollback();
            }
            catch (Exception exx) {
                rollBackFailed = true;
            }
            if (rollBackFailed) {
                throw new MetaDataPersistenceError("Failed to delete idEntity " + className + " with id " + idEntity.getId() + ":\n" + ex.getMessage(), ex);
            }
            throw new MetaDataPersistenceError("Failed to delete idEntity " + className + " with id " + idEntity.getId() + ":\n" + ex.getMessage(), ex);
        }
    }

    void persistIdEntity(BaseEntity idEntity) throws MetaDataPersistenceError {
        String className = idEntity.getClass().getSimpleName();
        LOGGER.fine("PersistenceController (results_metadata): persistIdEntity called for idEntity " + className + " with id " + idEntity.getId());
        EntityManager em = this.getEntityManager();
        try {
            em.getTransaction().begin();
            if (idEntity.getId() == null) {
                em.persist((Object)idEntity);
            } else {
                em.merge((Object)idEntity);
            }
            em.getTransaction().commit();
        }
        catch (Exception ex) {
            boolean rollBackFailed = false;
            try {
                em.getTransaction().rollback();
            }
            catch (Exception exx) {
                rollBackFailed = true;
            }
            if (rollBackFailed) {
                throw new MetaDataPersistenceError("Failed to persist idEntity " + className + " with id " + idEntity.getId() + ":\n" + ex.getMessage(), ex);
            }
            throw new MetaDataPersistenceError("Failed to persist idEntity " + className + " with id " + idEntity.getId() + ":\n" + ex.getMessage(), ex);
        }
    }

    void refreshIdEntity(BaseEntity idEntity) throws MetaDataPersistenceError {
        String className = idEntity.getClass().getSimpleName();
        LOGGER.fine("PersistenceController (results_metadata): refreshIdEntity called for idEntity " + className + " with id " + idEntity.getId());
        EntityManager em = this.getEntityManager();
        try {
            em.refresh((Object)idEntity);
        }
        catch (Exception ex) {
            throw new MetaDataPersistenceError("Failed to refresh idEntity " + className + " with id " + idEntity.getId() + ":\n" + ex.getMessage(), ex);
        }
    }

    public void forceInitialize() throws MetaDataPersistenceError {
        try {
            EntityManager em = this.getEntityManager();
            if (em == null) {
                throw new IllegalStateException("EntityManager requested by PersistenceController is null!");
            }
        }
        catch (Exception ex) {
            throw new MetaDataPersistenceError("Failed to initialize metadata persistence:\n" + ex.getMessage(), ex);
        }
    }

    private EntityManager getEntityManager() {
        if (this.entityManagerFactory == null) {
            this.entityManagerFactory = DatabaseJPAConnectorImpl.getEntityManagerFactory((DatabaseConfiguration)config, (String)PERSISTENCE_UNIT, (ClassLoader)this.getClass().getClassLoader());
        }
        if (this.entityManager == null) {
            this.entityManager = this.entityManagerFactory.createEntityManager();
        }
        return this.entityManager;
    }

    public static synchronized void setDefaultPath(String testDataPath) {
        if (instance == null) {
            DEFAULTTCONFIG = DatabaseConfiguration.createH2((String)"byteblower", (String)"excentis", (String)testDataPath, (String)"byteblower_results_metadata");
        }
    }

    public void addTag(TestDataReference testDataReference, String tagName) {
        Tag tag2;
        MetaTagManager tagManager = new MetaTagManager(this);
        for (Tag tag2 : testDataReference.getTags()) {
            if (!tag2.getName().equals(tagName)) continue;
            return;
        }
        tag2 = new Tag(testDataReference, tagName);
        tagManager.persistIdEntity(tag2);
        if (tag2.getId() == null) {
            throw new IllegalStateException("Tag entity should have valid id after persisting.");
        }
    }
}

