/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.dataprovider.data;

import com.excentis.products.byteblower.datalibs.DatabaseModifier;
import com.excentis.products.byteblower.datalibs.DatabaseType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

class MetaDatabaseUpdater
implements DatabaseModifier {
    private static final Logger LOGGER = Logger.getGlobal();

    MetaDatabaseUpdater() {
    }

    private int version(int ... nums) {
        int versionNumber = 0;
        int ctr = 0;
        while (ctr < nums.length && ctr < 4) {
            versionNumber = (versionNumber << 8) + nums[ctr];
            ++ctr;
        }
        return versionNumber;
    }

    private int getVersion(Connection connection) throws SQLException {
        ResultSet set = connection.prepareStatement("SELECT METADATA_VERSION FROM METADATA_INFO").executeQuery();
        if (!set.next()) {
            return this.version(0, 0, 0);
        }
        String version = set.getString(1);
        String[] strNums = version.split(Pattern.quote("."));
        int[] nums = new int[strNums.length];
        int ctr = 0;
        while (ctr < strNums.length) {
            String strNumber = strNums[ctr];
            try {
                int versionPart;
                nums[ctr] = versionPart = Integer.parseInt(strNumber);
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.WARNING, "Does not recognize test database version: " + version);
                return -1;
            }
            ++ctr;
        }
        return this.version(nums);
    }

    public boolean doUpdate(Connection connection, DatabaseType type) throws SQLException {
        boolean success = true;
        int connectionVersion = this.getVersion(connection);
        if (connectionVersion < this.version(2, 5, 99)) {
            success = this.update_2_5_99(connection);
        }
        return success;
    }

    private boolean update_2_5_99(Connection connection) throws SQLException {
        String ADD_TEST_RUN = "ALTER TABLE `testdata_reference` ADD IF NOT EXISTS `testrun_title` VARCHAR(21844) NULL";
        connection.prepareStatement("ALTER TABLE `testdata_reference` ADD IF NOT EXISTS `testrun_title` VARCHAR(21844) NULL").execute();
        String ADD_TAGS_TABLE = "CREATE TABLE IF NOT EXISTS `tag` ( `id` BIGINT(20) NOT NULL AUTO_INCREMENT,  `name` VARCHAR(21844) NOT NULL,  `testdata_reference_id` BIGINT(20) NOT NULL,  PRIMARY KEY (`id`),  INDEX `fk_tag_testdata_reference1_idx` (`testdata_reference_id` ASC),  UNIQUE INDEX `unique_index` (`name` ASC, `testdata_reference_id` ASC),  CONSTRAINT `fk_tag_testdata_reference1`    FOREIGN KEY (`testdata_reference_id`)    REFERENCES `testdata_reference` (`id`)    ON DELETE NO ACTION    ON UPDATE NO ACTION);";
        connection.prepareStatement("CREATE TABLE IF NOT EXISTS `tag` ( `id` BIGINT(20) NOT NULL AUTO_INCREMENT,  `name` VARCHAR(21844) NOT NULL,  `testdata_reference_id` BIGINT(20) NOT NULL,  PRIMARY KEY (`id`),  INDEX `fk_tag_testdata_reference1_idx` (`testdata_reference_id` ASC),  UNIQUE INDEX `unique_index` (`name` ASC, `testdata_reference_id` ASC),  CONSTRAINT `fk_tag_testdata_reference1`    FOREIGN KEY (`testdata_reference_id`)    REFERENCES `testdata_reference` (`id`)    ON DELETE NO ACTION    ON UPDATE NO ACTION);").execute();
        this.setInitialVersion(connection, 2, 5, 99);
        return true;
    }

    private void setInitialVersion(Connection connection, int major, int minor, int patch) throws SQLException {
        String versionString = String.valueOf(major) + "." + minor + "." + patch;
        PreparedStatement statement = connection.prepareStatement("INSERT INTO METADATA_INFO (METADATA_VERSION) VALUES ('" + versionString + "')");
        statement.execute();
    }

    private void setVersion(Connection connection, int major, int minor, int patch) throws SQLException {
        String versionString = String.valueOf(major) + "." + minor + "." + patch;
        PreparedStatement statement = connection.prepareStatement("UPDATE METADATA_INFO SET METADATA_VERSION='" + versionString + "'");
        statement.execute();
    }
}

