/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.postprocessing;

import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.postprocessing.PostProcessor;
import com.excentis.products.byteblower.results.testdata.data.EventManager;
import com.excentis.products.byteblower.results.testdata.data.FbFlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.FlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.ScenarioManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbSource;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTrigger;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4Address;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4Session;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.PortEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbTriggerReader;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.osgi.framework.Version;

class NatSuggestion
extends PostProcessor {
    private static final String ENABLE_NAT_ARTICLE = "https://support.excentis.com/index.php?/Knowledgebase/Article/View/98/0/howto-testing-nat-device-with-byteblower";
    private static final Version version = new Version(0, 0, 8);

    public NatSuggestion() {
        super("NATSuggestion", version);
    }

    private boolean alreadyNat(Port port) {
        Layer3 layer3 = port.getLayer3();
        if (layer3 instanceof Layer3Ipv4) {
            Layer3Ipv4 ipv4 = (Layer3Ipv4)layer3;
            return ipv4.getNatConfiguration() != null;
        }
        return false;
    }

    private boolean inRange(Ipv4Address address, int ... mask) {
        byte[] data = address.getAddress();
        if (data.length != mask.length) {
            return false;
        }
        int ctr = 0;
        while (ctr < data.length) {
            if (mask[ctr] != 0 && data[ctr] != (byte)mask[ctr]) {
                return false;
            }
            ++ctr;
        }
        return true;
    }

    private boolean maybeLocal(Port port) {
        Layer3 layer3 = port.getLayer3();
        if (layer3 instanceof Layer3Ipv4) {
            Layer3Ipv4 ipv4 = (Layer3Ipv4)layer3;
            Layer3Ipv4Session session = ipv4.getSession();
            if (session == null) {
                return false;
            }
            Ipv4Address addressEntity = session.getAddress();
            if (addressEntity == null) {
                return false;
            }
            boolean local = this.inRange(addressEntity, 10, 0, 0, 0) || this.inRange(addressEntity, 172, 16, 0, 0) || this.inRange(addressEntity, 192, 168, 0, 0);
            return local;
        }
        return false;
    }

    @Override
    public void process(TestDataReference reference) {
        TestDataPersistenceController control = TestDataPersistenceController.getInstance((Long)reference.getId());
        FlowInstanceManager manager = new FlowInstanceManager(control);
        String scenarioName = reference.getTestName();
        ScenarioManager scmanager = new ScenarioManager(control);
        Scenario scenario = scmanager.find(scenarioName);
        List fbFlows = manager.getAllFrameBlasting(scenario);
        for (FbFlowInstance flowInstance : fbFlows) {
            FbFlowInstanceReader flowReader = EntityReaderFactory.create((FbFlowInstance)flowInstance);
            FbSource source = flowReader.getSource();
            if (source == null) continue;
            FbTrigger sourceTrigger = source.getTrigger();
            Port sourcePort = source.getPort();
            if (this.alreadyNat(sourcePort) || sourceTrigger == null) continue;
            boolean localSource = this.maybeLocal(sourcePort);
            long sourceBytes = sourceTrigger.getByteCount();
            if (!flowReader.isConfigured()) continue;
            FbFlowInstanceManager flowManager = new FbFlowInstanceManager(control);
            Set destinations = flowManager.getFbDestinationsAndEavesdroppers(flowInstance);
            for (FbDestination destination : destinations) {
                FbTrigger destinationTrigger = destination.getTrigger();
                if (destinationTrigger == null) continue;
                FbTriggerReader destinationTriggerReader = EntityReaderFactory.create((FbTrigger)destinationTrigger);
                if (sourceBytes <= 0L || destinationTriggerReader.getByteCount() != 0L) continue;
                Port destinationPort = destination.getPort();
                boolean destinationLocal = destination != null && this.maybeLocal(destinationPort);
                EventManager evt = new EventManager(control);
                this.addSuggestion(sourcePort, localSource, destinationPort, destinationLocal, evt);
            }
        }
    }

    private void addSuggestion(Port sourcePort, boolean localSource, Port destinationPort, boolean destinationLocal, EventManager evt) {
        PortEvent event;
        if (destinationLocal && localSource) {
            String format = "The destination ('%s) and source ('%s') have local addresses.\nYou might want to enable NAT on these ports.\nClick here for more information.";
            String suggestion = String.format(format, destinationPort.getName(), sourcePort.getName());
            event = new PortEvent(new Date(), suggestion, EventSeverity.TEST_SUGGESTION, destinationPort);
        } else if (destinationLocal) {
            String format = "The destination (%s) has a local address.\nYou might want to enable NAT on this port.\nClick here for more information.";
            String suggestion = String.format(format, destinationPort.getName());
            event = new PortEvent(new Date(), suggestion, EventSeverity.TEST_SUGGESTION, destinationPort);
        } else if (localSource) {
            String format = "The source (%s) has a local address.\nYou might want to enable NAT on this port.\nClick here for more information.";
            String suggestion = String.format(format, sourcePort.getName());
            event = new PortEvent(new Date(), suggestion, EventSeverity.TEST_SUGGESTION, sourcePort);
        } else {
            return;
        }
        event.setKnowledgebaseLink(ENABLE_NAT_ARTICLE);
        evt.persistIdEntity((BaseEntity)event);
    }
}

