/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.postprocessing;

import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.postprocessing.CanceledWirelessEndpoint;
import com.excentis.products.byteblower.results.postprocessing.CongestionWindowSizeSuggestion;
import com.excentis.products.byteblower.results.postprocessing.EmptyFbFlowSuggestion;
import com.excentis.products.byteblower.results.postprocessing.FBResultsTag;
import com.excentis.products.byteblower.results.postprocessing.LatencyLossSuggestion;
import com.excentis.products.byteblower.results.postprocessing.NatSuggestion;
import com.excentis.products.byteblower.results.postprocessing.NatTimeoutSuggestion;
import com.excentis.products.byteblower.results.postprocessing.PostProcessor;
import com.excentis.products.byteblower.results.postprocessing.SilentPortSuggesion;
import com.excentis.products.byteblower.results.testdata.data.PostProcessingManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.PostProcessingEngine;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PostProcessing {
    private static final Logger LOGGER = Logger.getGlobal();

    private boolean hasAlreadyRun(TestDataReference reference, PostProcessor processor) {
        TestDataPersistenceController control = TestDataPersistenceController.getInstance((Long)reference.getId());
        PostProcessingManager mgr = new PostProcessingManager(control);
        PostProcessingEngine engine = mgr.find(processor.name());
        return engine != null && engine.getVersion().compareTo(processor.version()) >= 0;
    }

    private void persistRun(TestDataReference reference, PostProcessor processor) {
        TestDataPersistenceController control = TestDataPersistenceController.getInstance((Long)reference.getId());
        PostProcessingManager mgr = new PostProcessingManager(control);
        PostProcessingEngine old = mgr.find(processor.name());
        if (old == null) {
            mgr.persistIdEntity((BaseEntity)new PostProcessingEngine(processor.name(), processor.version()));
        } else {
            old.setVersion(processor.version());
            mgr.persistIdEntity((BaseEntity)old);
        }
    }

    public void run(TestDataReference reference) {
        PostProcessor[] suggestions;
        PostProcessor[] postProcessorArray = suggestions = new PostProcessor[]{new NatSuggestion(), new LatencyLossSuggestion(), new CongestionWindowSizeSuggestion(), new NatTimeoutSuggestion(), new SilentPortSuggesion(), new EmptyFbFlowSuggestion(), new FBResultsTag(), new CanceledWirelessEndpoint()};
        int n = suggestions.length;
        int n2 = 0;
        while (n2 < n) {
            PostProcessor engine = postProcessorArray[n2];
            if (!this.hasAlreadyRun(reference, engine)) {
                try {
                    engine.process(reference);
                    this.persistRun(reference, engine);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Failed to process " + engine.name(), e);
                }
            }
            ++n2;
        }
    }
}

