/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data;

import com.excentis.products.byteblower.results.testdata.data.BaseEntityManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceError;
import com.excentis.products.byteblower.results.testdata.data.entities.AddressResolution;
import com.excentis.products.byteblower.results.testdata.data.entities.AddressResolutionIpv4;
import com.excentis.products.byteblower.results.testdata.data.entities.AddressResolutionIpv4_;
import com.excentis.products.byteblower.results.testdata.data.entities.AddressResolutionIpv6;
import com.excentis.products.byteblower.results.testdata.data.entities.AddressResolutionIpv6_;
import com.excentis.products.byteblower.results.testdata.data.entities.AddressResolution_;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4Address;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv6Address;
import com.excentis.products.byteblower.results.testdata.data.entities.MacAddress;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;

public class AddressResolutionManager
extends BaseEntityManager<AddressResolution> {
    public AddressResolutionManager(TestDataPersistenceController pc) {
        super(AddressResolution.class, pc);
    }

    public AddressResolutionIpv4 createOrUpdate(Scenario scenario, Port resolverPort, Ipv4Address ipv4Address, MacAddress resolvedMacAddress) throws TestDataPersistenceError {
        AddressResolutionIpv4 dbEntity = this.find(scenario, resolverPort, ipv4Address);
        if (dbEntity == null) {
            dbEntity = new AddressResolutionIpv4(scenario, resolverPort, ipv4Address, resolvedMacAddress);
            this.persistIdEntity(dbEntity);
        } else {
            dbEntity.setResolvedMacAddress(resolvedMacAddress);
            this.persistIdEntity(dbEntity);
        }
        return dbEntity;
    }

    public AddressResolutionIpv6 createOrUpdate(Scenario scenario, Port resolverPort, Ipv6Address ipv6Address, MacAddress resolvedMacAddress) throws TestDataPersistenceError {
        AddressResolutionIpv6 dbEntity = this.find(scenario, resolverPort, ipv6Address);
        if (dbEntity == null) {
            dbEntity = new AddressResolutionIpv6(scenario, resolverPort, ipv6Address, resolvedMacAddress);
            this.persistIdEntity(dbEntity);
        } else {
            dbEntity.setResolvedMacAddress(resolvedMacAddress);
            this.persistIdEntity(dbEntity);
        }
        return dbEntity;
    }

    public AddressResolutionIpv4 find(Scenario scenario, Port resolverPort, Ipv4Address ipv4Address) throws TestDataPersistenceError {
        CriteriaBuilder qb = this.controller.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(AddressResolutionIpv4.class);
        Root addressMappings = query.from(AddressResolutionIpv4.class);
        query.where((Expression)qb.and(new Predicate[]{qb.equal((Expression)addressMappings.get(AddressResolution_.scenario), (Object)scenario), qb.equal((Expression)addressMappings.get(AddressResolution_.resolverPort), (Object)resolverPort), qb.equal((Expression)addressMappings.get(AddressResolutionIpv4_.ipv4Address), (Object)ipv4Address)}));
        return (AddressResolutionIpv4)this.controller.getEntity(query);
    }

    public AddressResolutionIpv6 find(Scenario scenario, Port resolverPort, Ipv6Address ipv6Address) throws TestDataPersistenceError {
        CriteriaBuilder qb = this.controller.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(AddressResolutionIpv6.class);
        Root addressMappings = query.from(AddressResolutionIpv6.class);
        query.where((Expression)qb.and(new Predicate[]{qb.equal((Expression)addressMappings.get(AddressResolution_.scenario), (Object)scenario), qb.equal((Expression)addressMappings.get(AddressResolution_.resolverPort), (Object)resolverPort), qb.equal((Expression)addressMappings.get(AddressResolutionIpv6_.ipv6Address), (Object)ipv6Address)}));
        return (AddressResolutionIpv6)this.controller.getEntity(query);
    }
}

