/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data;

import com.excentis.products.byteblower.results.testdata.data.BaseEntityManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceError;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfig;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfigFixedIpv4;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfigFixedIpv6;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfigMulticast;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfigUnicast;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import java.util.HashSet;
import java.util.Set;

public class FbFlowInstanceManager
extends BaseEntityManager<FbFlowInstance> {
    public FbFlowInstanceManager(TestDataPersistenceController pc) {
        super(FbFlowInstance.class, pc);
    }

    public Set<FbDestination> getFbDestinations(FbFlowInstance fbFlowInstance) throws TestDataPersistenceError {
        HashSet<FbDestination> set = new HashSet<FbDestination>();
        FbDestinationConfig destinationConfig = fbFlowInstance.getDestinationConfig();
        if (destinationConfig instanceof FbDestinationConfigMulticast) {
            FbDestinationConfigMulticast multicastConfig = (FbDestinationConfigMulticast)destinationConfig;
            set.addAll(multicastConfig.getDestinations());
        } else if (destinationConfig instanceof FbDestinationConfigUnicast) {
            FbDestinationConfigUnicast unicastConfig = (FbDestinationConfigUnicast)destinationConfig;
            set.add(unicastConfig.getDestination());
        } else if (!(destinationConfig instanceof FbDestinationConfigFixedIpv4)) {
            boolean cfr_ignored_0 = destinationConfig instanceof FbDestinationConfigFixedIpv6;
        }
        return set;
    }

    public Set<FbDestination> getFbDestinationsAndEavesdroppers(FbFlowInstance fbFlowInstance) throws TestDataPersistenceError {
        HashSet<FbDestination> set = new HashSet<FbDestination>();
        set.addAll(this.getFbDestinations(fbFlowInstance));
        set.addAll(fbFlowInstance.getDestinationConfig().getEavesdroppers());
        return set;
    }

    public FbDestination getFbDestination(FbFlowInstance fbFlowInstance, String portName) throws TestDataPersistenceError {
        for (FbDestination fbDestination : this.getFbDestinationsAndEavesdroppers(fbFlowInstance)) {
            if (!fbDestination.getPort().getName().equals(portName)) continue;
            return fbDestination;
        }
        return null;
    }
}

