/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data;

import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSessionSnapshot;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.Query;
import java.util.HashMap;
import java.util.logging.Logger;

public class IntervalHttpSnapshotManager {
    private HashMap<Long, Long> lastSnapShot = new HashMap();
    private final TestDataPersistenceController controller;

    public IntervalHttpSnapshotManager(TestDataPersistenceController pc) {
        this.controller = pc;
    }

    public void intervalSnapshot(HttpSessionSnapshot sample) {
        long httpSessionId = sample.getHttpSession().getId();
        long timeStamp = sample.getSnapshotTime();
        boolean doUpdate = false;
        if (this.lastSnapShot.containsKey(httpSessionId)) {
            long lastStoredTimeStamp = this.lastSnapShot.get(httpSessionId);
            if (timeStamp < lastStoredTimeStamp) {
                return;
            }
            if (timeStamp == lastStoredTimeStamp) {
                doUpdate = true;
            }
        }
        EntityManager em = this.controller.getEntityManager();
        EntityTransaction transaction = em.getTransaction();
        transaction.begin();
        int pCtr = 1;
        int updated = 0;
        if (doUpdate) {
            Query updatecumulative = em.createNativeQuery("UPDATE `http_session_snapshot` SET `snapshot_duration` =?, `tx_byte_count` =?, `rx_byte_count` =? WHERE                                                 `http_session_id` = ? AND  `snapshot_time` =?");
            updatecumulative.setParameter(pCtr++, (Object)sample.getSnapshotDuration());
            updatecumulative.setParameter(pCtr++, (Object)sample.getTxByteCount());
            updatecumulative.setParameter(pCtr++, (Object)sample.getRxByteCount());
            updatecumulative.setParameter(pCtr++, (Object)sample.getHttpSession().getId());
            updatecumulative.setParameter(pCtr++, (Object)sample.getSnapshotTime());
            updated = updatecumulative.executeUpdate();
        }
        if (updated == 0) {
            Query insertcumulative = em.createNativeQuery("INSERT INTO `http_session_snapshot` ( `http_session_id` , `snapshot_time` , `snapshot_duration` , `tx_byte_count` , `rx_byte_count` ) VALUES( ?,  ?,  ?,  ?,  ?) ");
            pCtr = 1;
            insertcumulative.setParameter(pCtr++, (Object)sample.getHttpSession().getId());
            insertcumulative.setParameter(pCtr++, (Object)sample.getSnapshotTime());
            insertcumulative.setParameter(pCtr++, (Object)sample.getSnapshotDuration());
            insertcumulative.setParameter(pCtr++, (Object)sample.getTxByteCount());
            insertcumulative.setParameter(pCtr++, (Object)sample.getRxByteCount());
            insertcumulative.executeUpdate();
        } else if (updated > 1) {
            Logger.getGlobal().severe("TODO should rollback");
        }
        if (this.lastSnapShot.containsKey(httpSessionId)) {
            this.lastSnapShot.put(httpSessionId, Math.max(this.lastSnapShot.get(httpSessionId), timeStamp));
        } else {
            this.lastSnapShot.put(httpSessionId, timeStamp);
        }
        transaction.commit();
    }

    public long findIntervalSnapshot(long snapshotTimestamp, long httpSessionId) {
        EntityManager em = this.controller.getEntityManager();
        Query getId = em.createNativeQuery("SELECT `id` FROM `http_session_snapshot` WHERE `http_session_id` = ? AND `snapshot_time` = ?");
        int pCtr = 1;
        getId.setParameter(pCtr++, (Object)httpSessionId);
        getId.setParameter(pCtr++, (Object)snapshotTimestamp);
        try {
            Long id = (Long)getId.getSingleResult();
            return id;
        }
        catch (Exception e) {
            System.err.println("problem fetching results:");
            System.err.println(e.getMessage());
            e.printStackTrace();
            return -1L;
        }
    }
}

