/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data;

import com.excentis.products.byteblower.results.testdata.data.BaseEntityManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceConversionError;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceError;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4Address;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4Address_;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv4AddressUtility;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;

public class Ipv4AddressManager
extends BaseEntityManager<Ipv4Address> {
    public Ipv4AddressManager(TestDataPersistenceController pc) {
        super(Ipv4Address.class, pc);
    }

    public Ipv4Address findOrCreate(String ipv4AddressString) throws TestDataPersistenceError, TestDataPersistenceConversionError {
        return this.findOrCreate(Ipv4AddressUtility.convertToBinary(ipv4AddressString));
    }

    public Ipv4Address findOrCreate(byte[] ipv4Binary) throws TestDataPersistenceError {
        Ipv4Address dbEntity = this.find(ipv4Binary);
        if (dbEntity == null) {
            dbEntity = new Ipv4Address(ipv4Binary);
            this.persistIdEntity(dbEntity);
        }
        return dbEntity;
    }

    public Ipv4Address find(String ipv4AddressString) throws TestDataPersistenceError, TestDataPersistenceConversionError {
        return this.find(Ipv4AddressUtility.convertToBinary(ipv4AddressString));
    }

    public Ipv4Address find(byte[] ipv4Binary) throws TestDataPersistenceError {
        CriteriaBuilder qb = this.controller.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Ipv4Address.class);
        Root addresses = query.from(Ipv4Address.class);
        query.where((Expression)qb.equal((Expression)addresses.get(Ipv4Address_.address), (Object)ipv4Binary));
        return (Ipv4Address)this.controller.getEntity(query);
    }
}

