/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data;

import com.excentis.products.byteblower.results.testdata.data.BaseEntityManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceConversionError;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceError;
import com.excentis.products.byteblower.results.testdata.data.entities.MacAddress;
import com.excentis.products.byteblower.results.testdata.data.entities.MacAddress_;
import com.excentis.products.byteblower.results.testdata.data.utils.MacAddressUtility;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;

public class MacAddressManager
extends BaseEntityManager<MacAddress> {
    public MacAddressManager(TestDataPersistenceController pc) {
        super(MacAddress.class, pc);
    }

    public MacAddress findOrCreate(String macAddressString) throws TestDataPersistenceError, TestDataPersistenceConversionError {
        return this.findOrCreate(MacAddressUtility.convertToBinary(macAddressString));
    }

    public MacAddress findOrCreate(byte[] macBinary) throws TestDataPersistenceError {
        MacAddress dbEntity = this.find(macBinary);
        if (dbEntity == null) {
            dbEntity = new MacAddress(macBinary);
            this.persistIdEntity(dbEntity);
        }
        return dbEntity;
    }

    public MacAddress find(String macAddressString) throws TestDataPersistenceError, TestDataPersistenceConversionError {
        return this.find(MacAddressUtility.convertToBinary(macAddressString));
    }

    public MacAddress find(byte[] macBinary) throws TestDataPersistenceError {
        CriteriaBuilder qb = this.controller.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(MacAddress.class);
        Root addresses = query.from(MacAddress.class);
        query.where((Expression)qb.equal((Expression)addresses.get(MacAddress_.address), (Object)macBinary));
        return (MacAddress)this.controller.getEntity(query);
    }
}

