/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data;

import com.excentis.products.byteblower.datalibs.DatabaseConfiguration;
import com.excentis.products.byteblower.datalibs.DatabaseGenerator;
import com.excentis.products.byteblower.datalibs.DatabaseJPAConnectorImpl;
import com.excentis.products.byteblower.datalibs.DatabaseModifier;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceCookie;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceError;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatencySnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.FbOutOfSequenceSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTrigger;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTriggerSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.utils.DatabaseUpdater;
import com.excentis.products.byteblower.results.testdata.generator.DatabaseNameFactory;
import com.excentis.products.byteblower.results.testdata.generator.TestDataPersistenceGenerationError;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Root;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.DatabaseQuery;

public class TestDataPersistenceController {
    private static final String PERSISTENCE_UNIT = "com.excentis.products.byteblower.results.testdata";
    private static final Logger LOGGER = Logger.getGlobal();
    private static ArrayList<WeakReference<TestDataPersistenceController>> instances = new ArrayList();
    private static DatabaseNameFactory namingFactory = new DatabaseNameFactory();
    private EntityManagerFactory emFactory;
    private EntityManager entityManager;
    private final long testId;
    private final DatabaseConfiguration config;

    protected void finalize() throws Throwable {
        this.entityManager.close();
        super.finalize();
    }

    public static String saveLocation() {
        return namingFactory.saveLocation();
    }

    private TestDataPersistenceController(long testId, DatabaseConfiguration config) {
        this.testId = testId;
        this.config = config;
        this.emFactory = null;
        this.entityManager = null;
    }

    public static synchronized TestDataPersistenceController getInstance(Long testId) {
        if (testId == null) {
            throw new IllegalArgumentException("Failed to retrieve test data persistence controller; null test id provided");
        }
        TestDataPersistenceController controller = null;
        for (WeakReference<TestDataPersistenceController> ref : instances) {
            TestDataPersistenceController current = (TestDataPersistenceController)ref.get();
            if (current == null || testId.longValue() != current.getTestId()) continue;
            controller = current;
            break;
        }
        TestDataPersistenceController.cleanInstances();
        if (controller != null) {
            return controller;
        }
        try {
            DatabaseConfiguration config = namingFactory.generate(testId);
            DatabaseGenerator generator = new DatabaseGenerator(config);
            URL platformFileURL = new URL("platform:/plugin/com.excentis.products.byteblower.results.testdata.plugin/dbgenerator/script.sql");
            String sqlScript = IOUtils.toString((InputStream)platformFileURL.openStream(), (String)"UTF-8");
            generator.performDatabaseGeneration(sqlScript, (DatabaseModifier)new DatabaseUpdater());
            TestDataPersistenceController instance = new TestDataPersistenceController(testId, config);
            instances.add(new WeakReference<TestDataPersistenceController>(instance));
            return instance;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not generate test database", e);
            throw new TestDataPersistenceGenerationError("Not able to generate test db: \n" + e.getMessage());
        }
    }

    private static void cleanInstances() {
        ArrayList<WeakReference<TestDataPersistenceController>> inMemory = new ArrayList<WeakReference<TestDataPersistenceController>>();
        for (WeakReference<TestDataPersistenceController> ref : instances) {
            if (ref.get() == null) continue;
            inMemory.add(ref);
        }
        instances = inMemory;
    }

    public static synchronized void setDefaultPath(String testDataPath) {
        namingFactory = new DatabaseNameFactory(testDataPath);
    }

    <T extends BaseEntity> T getEntity(Class<T> idEntityType, Long id) {
        if (idEntityType == null) {
            throw new IllegalArgumentException("Failed to retrieve id entity; null entity type provided");
        }
        if (id == null) {
            throw new IllegalArgumentException("Failed to retrieve id entity; null id provided");
        }
        String className = idEntityType.getSimpleName();
        LOGGER.fine("PersistenceController (results_testdata_" + this.testId + "): getEntity called for idEntity " + className + " with id " + id);
        EntityManager em = this.getEntityManager();
        try {
            return (T)((BaseEntity)em.find(idEntityType, (Object)id));
        }
        catch (PersistenceException ex) {
            throw new TestDataPersistenceError("Failed to retrieve idEntity " + className + " with id " + id + ":\n" + ex.getMessage(), ex);
        }
    }

    public long getTestId() {
        return this.testId;
    }

    <T> List<T> getEntities(Class<T> entityType) throws TestDataPersistenceError {
        if (entityType == null) {
            throw new IllegalArgumentException("Failed to retrieve entities; null entity type provided");
        }
        String className = entityType.getSimpleName();
        LOGGER.fine("PersistenceController (results_testdata_" + this.testId + "): getEntities called for entity " + className);
        CriteriaBuilder qb = this.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(entityType);
        Root entities = query.from(entityType);
        return this.getEntities(query);
    }

    CriteriaBuilder getCriteriaBuilder() {
        return this.getEntityManager().getCriteriaBuilder();
    }

    <T> T getEntity(CriteriaQuery<T> criteriaQuery) throws TestDataPersistenceError {
        if (criteriaQuery == null) {
            throw new IllegalArgumentException("Failed to retrieve entity; null query provided");
        }
        EntityManager entityManager = this.getEntityManager();
        if (!entityManager.isOpen()) {
            return null;
        }
        TypedQuery typedQuery = entityManager.createQuery(criteriaQuery);
        String className = criteriaQuery.getResultType().getSimpleName();
        String queryString = this.getQueryString(typedQuery);
        LOGGER.fine("PersistenceController (results_testdata_" + this.testId + "): getEntity called for idEntity " + className + " using query:\n" + queryString);
        Object entityFromDb = null;
        try {
            entityFromDb = typedQuery.getSingleResult();
        }
        catch (NoResultException noResultException) {
        }
        catch (NonUniqueResultException ex) {
            throw new TestDataPersistenceError("Failed to retrieve idEntity " + className + " with query\n" + queryString + "\nMultiple results retrieved unexpectedly (restrictions too loose?)", ex);
        }
        catch (PersistenceException ex) {
            throw new TestDataPersistenceError("Failed to retrieve idEntity " + className + " with query\n" + queryString + ":\n" + ex.getMessage(), ex);
        }
        return (T)entityFromDb;
    }

    <T> String getQueryString(TypedQuery<T> typedQuery) {
        JpaQuery jpaQuery = (JpaQuery)typedQuery.unwrap(JpaQuery.class);
        DatabaseQuery databaseQuery = jpaQuery.getDatabaseQuery();
        String queryString = databaseQuery.getJPQLString();
        return queryString;
    }

    <T> List<T> getEntities(CriteriaQuery<T> criteriaQuery) throws TestDataPersistenceError {
        if (criteriaQuery == null) {
            throw new IllegalArgumentException("Failed to retrieve entities; null query provided");
        }
        TypedQuery typedQuery = this.getEntityManager().createQuery(criteriaQuery);
        List entitiesFromDb = null;
        try {
            entitiesFromDb = typedQuery.getResultList();
        }
        catch (PersistenceException ex) {
            String className = criteriaQuery.getResultType().getSimpleName();
            String queryString = ((JpaQuery)typedQuery.unwrap(JpaQuery.class)).getDatabaseQuery().getJPQLString();
            LOGGER.fine("PersistenceController (results_testdata_" + this.testId + "): getEntities called for idEntity " + className + " using query:\n" + queryString);
            throw new TestDataPersistenceError("Failed to retrieve idEntities " + className + " with query\n" + queryString + ":\n" + ex.getMessage(), ex);
        }
        return entitiesFromDb;
    }

    void persistIdEntity(BaseEntity idEntity) throws TestDataPersistenceError {
        if (idEntity == null) {
            throw new IllegalArgumentException("Failed to persist entity; null entity provided");
        }
        String className = idEntity.getClass().getSimpleName();
        LOGGER.fine("PersistenceController (results_testdata_" + this.testId + "): persistIdEntity called for idEntity " + className + " with id " + idEntity.getId());
        EntityManager em = this.getEntityManager();
        try {
            em.getTransaction().begin();
            if (idEntity.getId() == null) {
                em.persist((Object)idEntity);
            } else {
                em.merge((Object)idEntity);
            }
            em.getTransaction().commit();
        }
        catch (Exception ex) {
            boolean rollBackFailed = false;
            try {
                em.getTransaction().rollback();
            }
            catch (Exception exx) {
                Logger log = Logger.getGlobal();
                log.log(Level.SEVERE, "Problem rolling back database", exx);
                rollBackFailed = true;
            }
            if (rollBackFailed) {
                throw new TestDataPersistenceError("Rollback failed. Can't persist idEntity " + className + " with id " + idEntity.getId() + ":\n" + ex.getMessage(), ex);
            }
            throw new TestDataPersistenceError("Failed to persist idEntity " + className + " with id " + idEntity.getId() + ":\n" + ex.getMessage(), ex);
        }
    }

    void refreshIdEntity(BaseEntity idEntity) throws TestDataPersistenceError {
        if (idEntity == null) {
            throw new IllegalArgumentException("Failed to refresh entity; null entity provided");
        }
        String className = idEntity.getClass().getSimpleName();
        LOGGER.fine("PersistenceController (results_testdata_" + this.testId + "): refreshIdEntity called for idEntity " + className + " with id " + idEntity.getId());
        EntityManager em = this.getEntityManager();
        try {
            em.refresh((Object)idEntity);
        }
        catch (Exception ex) {
            throw new TestDataPersistenceError("Failed to refresh idEntity " + className + " with id " + idEntity.getId() + ":\n" + ex.getMessage(), ex);
        }
    }

    public void forceInitialize() throws TestDataPersistenceError {
        try {
            EntityManager em = this.getEntityManager();
            if (em == null) {
                throw new IllegalStateException("EntityManager requested by PersistenceController is null!");
            }
        }
        catch (Exception ex) {
            throw new TestDataPersistenceError("Failed to initialize test data persistence w/ id " + this.testId + ":\n" + ex.getMessage(), ex);
        }
    }

    private synchronized void checkEMFactory() {
        if (this.emFactory == null) {
            this.emFactory = DatabaseJPAConnectorImpl.getEntityManagerFactory((DatabaseConfiguration)this.config, (String)PERSISTENCE_UNIT, (ClassLoader)this.getClass().getClassLoader());
        }
    }

    public synchronized EntityManager getEntityManager() {
        if (this.entityManager == null) {
            this.checkEMFactory();
            this.entityManager = this.emFactory.createEntityManager();
        }
        return this.entityManager;
    }

    public void lightInsert(HttpSessionSnapshot snapshot) {
        String sql = "INSERT INTO http_session_snapshot(http_session_id,snapshot_time,snapshot_duration,tx_byte_count,rx_byte_count) VALUES (" + snapshot.getHttpSession().getId() + "," + snapshot.getSnapshotTime() + "," + snapshot.getSnapshotDuration() + "," + snapshot.getTxByteCount() + "," + snapshot.getRxByteCount() + ")";
        this.updateSql(sql);
    }

    public void lightInsert(FbTriggerSnapshot fbTriggerSnapshot) {
        String sql = "INSERT INTO fb_trigger_snapshot(trigger_id,snapshot_time,snapshot_duration,packet_count,byte_count) VALUES (" + fbTriggerSnapshot.getTrigger().getId() + "," + fbTriggerSnapshot.getSnapshotTime() + "," + fbTriggerSnapshot.getSnapshotDuration() + "," + fbTriggerSnapshot.getPacketCount() + "," + fbTriggerSnapshot.getByteCount() + ")";
        this.updateSql(sql);
    }

    public void lightInsert(FbLatencySnapshot fbTriggerSnapshot) {
        String sql = "INSERT INTO fb_latency_snapshot(latency_id,snapshot_time,snapshot_duration,packet_count_valid, latency_minimum,latency_average, latency_maximum,jitter) VALUES (" + fbTriggerSnapshot.getLatency().getId() + "," + fbTriggerSnapshot.getSnapshotTime() + "," + fbTriggerSnapshot.getSnapshotDuration() + "," + fbTriggerSnapshot.getPacketCountValid() + "," + fbTriggerSnapshot.getLatencyMinimum() + "," + fbTriggerSnapshot.getLatencyAverage() + "," + fbTriggerSnapshot.getLatencyMaximum() + "," + fbTriggerSnapshot.getJitter() + ")";
        this.updateSql(sql);
    }

    public void lightUpdate(FbLatencySnapshot entity) {
        if (this.isPersisted(entity)) {
            Long id = entity.getId();
            String sql = "UPDATE fb_latency_snapshot SET latency_id = " + entity.getLatency().getId() + ", " + "snapshot_time = '" + entity.getSnapshotTime() + "', " + "snapshot_duration = '" + entity.getSnapshotDuration() + "', " + "packet_count_valid = " + entity.getPacketCountValid() + ", " + "latency_minimum = " + entity.getLatencyMinimum() + ", " + "latency_average = " + entity.getLatencyAverage() + ", " + "latency_maximum = " + entity.getLatencyMaximum() + ", " + "jitter = " + entity.getJitter() + " WHERE id=" + id;
            this.updateSql(sql);
        } else {
            this.persistIdEntity(entity);
        }
    }

    public void lightUpdate(FbTrigger entity) {
        if (this.isPersisted(entity)) {
            Long id = entity.getId();
            String sql = "UPDATE fb_trigger SET first_packet_time = " + entity.getFirstPacketTime() + ", " + "last_packet_time = " + entity.getLastPacketTime() + ", " + "packet_count = " + entity.getPacketCount() + ", " + "byte_count = " + entity.getByteCount() + ", " + "snapshot_resolution = " + entity.getSnapshotResolution() + " WHERE id=" + id;
            this.updateSql(sql);
        } else {
            this.persistIdEntity(entity);
        }
    }

    public void lightUpdate(HttpSession entity) {
        if (this.isPersisted(entity)) {
            Long id = entity.getId();
            String sql = "UPDATE http_session SET application_http_id = " + entity.getHttpApplication().getId() + ", " + "tcp_session_id = " + entity.getTcpSession().getId() + ", " + "tx_first_byte_time = " + entity.getTxFirstByteTime() + ", " + "rx_first_byte_time = " + entity.getRxFirstByteTime() + ", " + "tx_last_byte_time = " + entity.getTxLastByteTime() + ", " + "rx_last_byte_time = " + entity.getRxLastByteTime() + ", " + "tx_byte_count = " + entity.getTxByteCount() + ", " + "rx_byte_count = " + entity.getRxByteCount() + ", " + "snapshot_resolution = " + entity.getSnapshotResolution() + " WHERE id=" + id;
            this.updateSql(sql);
        } else {
            this.persistIdEntity(entity);
        }
    }

    public void lightUpdate(HttpFlowInstance entity) {
        if (this.isPersisted(entity)) {
            Long id = entity.getId();
            String sql = "UPDATE http_flow_instance SET http_flow_template_id = " + entity.getFlowTemplate().getId() + ", " + "request_method = '" + (Object)((Object)entity.getRequestMethod()) + "', " + "request_status = '" + (Object)((Object)entity.getRequestStatus()) + "', " + "client_http_session_id = " + entity.getClientHttpSession().getId() + ", " + "server_http_session_id = " + entity.getServerHttpSession().getId() + " WHERE id=" + id;
            this.updateSql(sql);
        } else {
            this.persistIdEntity(entity);
        }
    }

    private void updateSql(String sql) {
        int updateCount = this.executeSql(sql);
        if (updateCount != 1) {
            LOGGER.warning("Update Failed !");
        }
    }

    private int executeSql(String sql) {
        int updateCount = 0;
        EntityManager em = this.getEntityManager();
        EntityTransaction transaction = em.getTransaction();
        transaction.begin();
        Query query = em.createNativeQuery(sql);
        updateCount = query.executeUpdate();
        transaction.commit();
        return updateCount;
    }

    private boolean isPersisted(BaseEntity entity) {
        return this.getEntityManager().contains((Object)entity);
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void lightInsert(BaseEntity entity) {
        if (entity instanceof FbTriggerSnapshot) {
            this.lightInsert((FbTriggerSnapshot)entity);
        } else if (entity instanceof HttpSessionSnapshot) {
            this.lightInsert((HttpSessionSnapshot)entity);
        } else if (entity instanceof FbLatencySnapshot) {
            this.lightInsert((FbLatencySnapshot)entity);
        } else {
            LOGGER.warning("TestDataPersistenceController::lightInsert : ERROR : unsupported entity class");
        }
    }

    public void lightUpdate(FbTriggerSnapshot entity) {
        if (this.isPersisted(entity)) {
            Long id = entity.getId();
            String sql = "UPDATE fb_trigger_snapshot SET trigger_id = " + entity.getTrigger().getId() + ", " + "snapshot_time = '" + entity.getSnapshotTime() + "', " + "snapshot_duration = '" + entity.getSnapshotDuration() + "', " + "packet_count = " + entity.getPacketCount() + ", " + "byte_count = " + entity.getByteCount() + " WHERE id=" + id;
            this.updateSql(sql);
        } else {
            this.persistIdEntity(entity);
        }
    }

    public void lightUpdate(FbOutOfSequenceSnapshot entity) {
        if (this.isPersisted(entity)) {
            Long id = entity.getId();
            String sql = "UPDATE fb_outofsequence_snapshot SET outofsequence_id = " + entity.getOutOfSequence().getId() + ", " + "snapshot_time = '" + entity.getSnapshotTime() + "', " + "snapshot_duration = '" + entity.getSnapshotDuration() + "', " + "packet_count_valid = " + entity.getPacketCountValid() + ", " + "packet_count_outofsequence = " + entity.getPacketCountOutOfSequence() + " WHERE id=" + id;
            this.updateSql(sql);
        } else {
            this.persistIdEntity(entity);
        }
    }

    public void lightUpdate(HttpSessionSnapshot entity) {
        if (this.isPersisted(entity)) {
            Long id = entity.getId();
            String sql = "UPDATE http_session_snapshot SET http_session_id = " + entity.getHttpSession().getId() + ", " + "snapshot_time = '" + entity.getSnapshotTime() + "', " + "snapshot_duration = '" + entity.getSnapshotDuration() + "', " + "tx_byte_count = " + entity.getTxByteCount() + ", " + "rx_byte_count = " + entity.getRxByteCount() + " WHERE id=" + id;
            this.updateSql(sql);
        } else {
            this.persistIdEntity(entity);
        }
    }

    public void lightUpdate(BaseEntity entity) {
        if (entity instanceof FbTrigger) {
            this.lightUpdate((FbTrigger)entity);
        } else if (entity instanceof HttpSession) {
            this.lightUpdate((HttpSession)entity);
        } else if (entity instanceof HttpFlowInstance) {
            this.lightUpdate((HttpFlowInstance)entity);
        } else if (entity instanceof FbTriggerSnapshot) {
            this.lightUpdate((FbTriggerSnapshot)entity);
        } else if (entity instanceof FbOutOfSequenceSnapshot) {
            this.lightUpdate((FbOutOfSequenceSnapshot)entity);
        } else if (entity instanceof FbLatencySnapshot) {
            this.lightUpdate((FbLatencySnapshot)entity);
        } else if (entity instanceof HttpSessionSnapshot) {
            this.lightUpdate((HttpSessionSnapshot)entity);
        } else {
            LOGGER.warning("TestDataPersistenceController::lightUpdate : ERROR : unsupported entity class");
        }
    }

    public String getPersistenceUrl() {
        return this.config.getUrl();
    }

    public static TestDataPersistenceCookie getCookie(long id) {
        TestDataPersistenceController ctrl = TestDataPersistenceController.getInstance(id);
        return new TestDataPersistenceCookie(ctrl);
    }

    public synchronized EntityManager createEntityManager() {
        this.checkEMFactory();
        return this.emFactory.createEntityManager();
    }

    public void persistIdEntity(BaseEntity[] idEntities) {
        if (idEntities.length == 0) {
            return;
        }
        EntityManager em = this.emFactory.createEntityManager();
        try {
            em.getTransaction().begin();
            BaseEntity[] baseEntityArray = idEntities;
            int n = idEntities.length;
            int n2 = 0;
            while (n2 < n) {
                BaseEntity idEntity = baseEntityArray[n2];
                if (idEntity.getId() == null) {
                    em.persist((Object)idEntity);
                } else {
                    em.merge((Object)idEntity);
                }
                ++n2;
            }
            em.getTransaction().commit();
        }
        catch (Exception ex) {
            boolean rollBackFailed = false;
            try {
                em.getTransaction().rollback();
            }
            catch (Exception exx) {
                Logger log = Logger.getGlobal();
                log.log(Level.SEVERE, "Problem rolling back database", exx);
                rollBackFailed = true;
            }
            String className = idEntities[0].getClass().getSimpleName();
            if (rollBackFailed) {
                throw new TestDataPersistenceError("Rollback failed. Can't persist idEntities " + className + ex.getMessage(), ex);
            }
            throw new TestDataPersistenceError("Failed to persist idEntity " + className + "\n" + ex.getMessage(), ex);
        }
        em.close();
    }
}

