/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@DiscriminatorColumn(name="type")
@Table(name="fb_destination_config")
public abstract class FbDestinationConfig
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @OneToOne
    @JoinColumn(name="flow_instance_id", unique=true, nullable=false)
    private FbFlowInstance flowInstance;
    @OneToMany
    @JoinTable(name="fb_eavesdropper_destination", joinColumns={@JoinColumn(name="fb_destination_config_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="fb_destination_id", referencedColumnName="id", unique=true)})
    private Set<FbDestination> eavesdroppers;

    public FbDestinationConfig(FbFlowInstance flowInstance) {
        if (flowInstance == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'flowInstance' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.flowInstance = flowInstance;
        this.flowInstance.setDestinationConfig(this);
        this.eavesdroppers = new HashSet<FbDestination>();
    }

    FbDestinationConfig() {
    }

    public FbFlowInstance getFlowInstance() {
        return this.flowInstance;
    }

    public Set<FbDestination> getEavesdroppers() {
        return Collections.unmodifiableSet(this.eavesdroppers);
    }

    public void addEavesdropper(FbDestination eavesdropper) {
        if (!this.eavesdroppers.contains(eavesdropper)) {
            this.eavesdroppers.add(eavesdropper);
        }
    }
}

