/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowTemplateFrame;
import com.excentis.products.byteblower.results.testdata.data.entities.FbStreamTimingModifier;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@Entity
@Table(name="fb_flow_template")
public class FbFlowTemplate
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @Column(name="name", length=21844, unique=true, nullable=false)
    private String name;
    @Column(name="frame_interval", nullable=false)
    private Long frameInterval;
    @OneToMany(mappedBy="flowTemplate")
    private List<FbFlowTemplateFrame> streamFrames;
    @OneToOne(mappedBy="flowTemplate")
    private FbStreamTimingModifier timingModifier;

    public FbFlowTemplate(String name, Long frameInterval) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'name' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (frameInterval == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'frameInterval' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.name = name;
        this.frameInterval = frameInterval;
        this.streamFrames = new ArrayList<FbFlowTemplateFrame>();
        this.timingModifier = null;
    }

    FbFlowTemplate() {
    }

    public String getName() {
        return this.name;
    }

    public Long getFrameInterval() {
        return this.frameInterval;
    }

    public List<FbFlowTemplateFrame> getFrames() {
        Collections.sort(this.streamFrames, new Comparator<FbFlowTemplateFrame>(){

            @Override
            public int compare(FbFlowTemplateFrame o1, FbFlowTemplateFrame o2) {
                return o1.getPosition().compareTo(o2.getPosition());
            }
        });
        return Collections.unmodifiableList(this.streamFrames);
    }

    void addFrame(FbFlowTemplateFrame streamFrame) {
        if (streamFrame == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'streamFrame' of type " + this.getClass().getSimpleName());
        }
        this.streamFrames.add(streamFrame);
    }

    public FbStreamTimingModifier getFbStreamTimingModifier() {
        return this.timingModifier;
    }

    void setTimingModifier(FbStreamTimingModifier timingModifier) {
        if (timingModifier == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'timingModifier' of type " + this.getClass().getSimpleName());
        }
        this.timingModifier = timingModifier;
    }
}

