/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.FbLatency;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatencyDistributionEntry;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Entity
@Table(name="fb_latency_distribution")
public class FbLatencyDistribution
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @OneToOne
    @JoinColumn(name="latency_id", nullable=false, unique=true)
    private FbLatency latency;
    @Column(name="latency_range_minimum", nullable=false)
    private long latencyRangeMinimum;
    @Column(name="latency_range_maximum", nullable=false)
    private long latencyRangeMaximum;
    @Column(name="bucket_count", nullable=false)
    private int bucketCount;
    @Column(name="bucket_width", nullable=false)
    private long bucketWidth;
    @Column(name="packet_count_below_minimum", nullable=false)
    private long packetCountBelowMinimum;
    @Column(name="packet_count_above_maximum", nullable=false)
    private long packetCountAboveMaximum;
    @OneToMany(mappedBy="distribution", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<FbLatencyDistributionEntry> distributionEntries;

    public FbLatencyDistribution(FbLatency latency, long latencyRangeMinimum, long latencyRangeMaximum, int bucketCount, long bucketWidth, long packetCountBelowMinimum, long packetCountAboveMaximum) {
        if (latency == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'latency' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.latency = latency;
        this.latency.setDistribution(this);
        this.latencyRangeMinimum = latencyRangeMinimum;
        this.latencyRangeMaximum = latencyRangeMaximum;
        this.bucketCount = bucketCount;
        this.bucketWidth = bucketWidth;
        this.packetCountBelowMinimum = packetCountBelowMinimum;
        this.packetCountAboveMaximum = packetCountAboveMaximum;
        this.distributionEntries = new HashSet<FbLatencyDistributionEntry>();
    }

    FbLatencyDistribution() {
        this.distributionEntries = new HashSet<FbLatencyDistributionEntry>();
    }

    public FbLatency getLatency() {
        return this.latency;
    }

    public long getLatencyRangeMinimum() {
        return this.latencyRangeMinimum;
    }

    public long getLatencyRangeMaximum() {
        return this.latencyRangeMaximum;
    }

    public int getBucketCount() {
        return this.bucketCount;
    }

    public long getBucketWidth() {
        return this.bucketWidth;
    }

    public long getPacketCountBelowMinimum() {
        return this.packetCountBelowMinimum;
    }

    public long getPacketCountAboveMaximum() {
        return this.packetCountAboveMaximum;
    }

    public Map<Long, Long> getEntries() {
        HashMap<Long, Long> distributionMap = new HashMap<Long, Long>();
        for (FbLatencyDistributionEntry distributionEntry : this.distributionEntries) {
            distributionMap.put(distributionEntry.getBucketStartLatency(), distributionEntry.getPacketCount());
        }
        return Collections.unmodifiableMap(distributionMap);
    }

    public void addEntry(long bucketStartLatency, long packetCount) {
        this.distributionEntries.add(new FbLatencyDistributionEntry(this, bucketStartLatency, packetCount));
    }
}

