/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.Flow;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.enums.FlowInstanceStatus;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@DiscriminatorColumn(name="type")
@Table(name="flow_instance")
public abstract class FlowInstance
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @JoinColumn(name="scenario_id", nullable=false)
    private Scenario scenario;
    @ManyToOne
    @JoinColumn(name="flow_id", nullable=false)
    private Flow flow;
    @Column(name="scenario_position", nullable=false)
    private Integer scenarioPosition;
    @Column(name="start_time", nullable=false)
    private Long startTime;
    @Column(name="duration")
    private Long duration;
    @Enumerated(value=EnumType.STRING)
    @Column(name="status", length=40, nullable=false)
    private FlowInstanceStatus status;
    @Column(name="tos", length=40, nullable=false)
    private String tos;
    @Column(name="parent")
    private Long parent;

    public FlowInstance(Scenario scenario, Flow flow, Integer scenarioPosition, Long startTime, Long duration, String tos) {
        if (scenario == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'scenario' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (flow == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'flow' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (scenarioPosition == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'scenarioPosition' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (startTime == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'startTime' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.scenario = scenario;
        this.scenario.addFlowInstance(this);
        this.flow = flow;
        this.scenarioPosition = scenarioPosition;
        this.startTime = startTime;
        this.duration = duration;
        this.status = FlowInstanceStatus.CREATED;
        this.tos = tos;
    }

    FlowInstance() {
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public Flow getFlow() {
        return this.flow;
    }

    public Integer getScenarioPosition() {
        return this.scenarioPosition;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getDuration() {
        return this.duration;
    }

    public String getTos() {
        if (this.tos == null) {
            return "Unknown";
        }
        return this.tos;
    }

    public FlowInstanceStatus getStatus() {
        return this.status;
    }

    public void setStatus(FlowInstanceStatus status) {
        if (status == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'status' of type " + this.getClass().getSimpleName());
        }
        this.status = status;
    }

    public void setParent(FlowInstance f) {
        this.parent = f.getId();
    }

    public Long getParent() {
        return this.parent;
    }
}

