/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.MulticastMember;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@DiscriminatorColumn(name="type")
@Table(name="multicast_configuration")
public abstract class MulticastConfiguration
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @Column(name="name", length=21844, unique=true, nullable=false)
    private String name;
    @OneToMany(mappedBy="multicastConfiguration")
    private Set<MulticastMember> members;

    public MulticastConfiguration(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'name' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.name = name;
        this.members = new HashSet<MulticastMember>();
    }

    MulticastConfiguration() {
    }

    public String getName() {
        return this.name;
    }

    public Set<MulticastMember> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    void addMember(MulticastMember multicastMember) {
        if (multicastMember == null) {
            throw new IllegalArgumentException("Cannot provide null value when adding multicast member to entity property 'members' of type " + this.getClass().getSimpleName());
        }
        if (!this.members.contains(multicastMember)) {
            this.members.add(multicastMember);
        }
    }
}

