/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4Address;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.enums.ServerConnectionState;
import com.excentis.products.byteblower.results.testdata.data.enums.ServerType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;

@Entity
@Table(name="server")
public class Server
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    private static final int MAX_DESCRIPTION_SIZE = 1024;
    @Column(name="url", length=21844, nullable=false)
    private String url;
    @Column(name="uuid", length=45, nullable=false)
    private String uuid;
    @Column(name="name", length=128)
    private String name;
    @Column(name="description", length=21844)
    private String description;
    @Enumerated(value=EnumType.STRING)
    @Column(name="connection_state", length=40, nullable=false)
    private ServerConnectionState connectionState;
    @ManyToOne
    @JoinColumn(name="ipv4_address_id", unique=true)
    private Ipv4Address ipv4Address;
    @Enumerated(value=EnumType.STRING)
    @Column(name="type", length=40)
    private ServerType type;
    @Column(name="version", length=40)
    private String version;

    public Server(String url, ServerConnectionState serverConnectionState, String uuid, String name, Ipv4Address ipv4Address, ServerType type, String version, String description) {
        if (url == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'url' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (serverConnectionState == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'serverConnectionState' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (serverConnectionState == ServerConnectionState.SUCCESS) {
            if (ipv4Address == null) {
                throw new IllegalArgumentException("Cannot provide null value for entity property 'ipv4Address' when constructing entity of type " + this.getClass().getSimpleName() + "with SUCCESS server connection states.");
            }
            if (type == null) {
                throw new IllegalArgumentException("Cannot provide null value for entity property 'type' when constructing entity of type " + this.getClass().getSimpleName() + "with SUCCESS server connection states.");
            }
            if (version == null) {
                throw new IllegalArgumentException("Cannot provide null value for entity property 'version' when constructing entity of type " + this.getClass().getSimpleName() + "with SUCCESS server connection states.");
            }
        }
        this.url = url;
        this.connectionState = serverConnectionState;
        this.ipv4Address = ipv4Address;
        this.name = name;
        this.uuid = uuid;
        this.type = type;
        this.version = version;
        this.description = description.substring(0, Math.min(1024, description.length()));
    }

    Server() {
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public String getUuid() {
        return this.uuid;
    }

    public ServerConnectionState getConnectionState() {
        return this.connectionState;
    }

    public Ipv4Address getIpv4Address() {
        return this.ipv4Address;
    }

    public ServerType getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }
}

