/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.Table;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaQuery;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="wifi_samples")
public class WiFiSample
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @Column(name="snapshot_time")
    private long timestamp;
    @Column(name="rssi")
    private long rssi;
    @Column(name="bssid")
    private String bssid;
    @Column(name="ssid")
    private String ssid;
    @Column(name="port_name")
    private String portname;
    @Column(name="net_interface")
    private String netinterface;

    WiFiSample() {
    }

    public WiFiSample(long timestamp, long rssi, String bssid, String ssid, String portname, String netinterface) {
        this.timestamp = timestamp;
        this.rssi = rssi;
        this.bssid = bssid;
        this.ssid = ssid;
        this.portname = portname;
        this.netinterface = netinterface;
    }

    public static void addSamples(TestDataPersistenceController pc, List<WiFiSample> samples) {
        EntityManager em = pc.createEntityManager();
        EntityTransaction trans = em.getTransaction();
        trans.begin();
        for (WiFiSample aSample : samples) {
            em.persist((Object)aSample);
        }
        trans.commit();
        em.close();
    }

    public static List<WiFiSample> getSamples(TestDataPersistenceController pc) {
        ArrayList<WiFiSample> result = new ArrayList<WiFiSample>();
        EntityManager em = pc.createEntityManager();
        CriteriaQuery baseQuery = em.getCriteriaBuilder().createQuery(WiFiSample.class);
        TypedQuery dd = em.createQuery(baseQuery);
        result.addAll(dd.getResultList());
        em.close();
        return result;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getRssi() {
        return this.rssi;
    }

    public String getBssid() {
        return this.bssid;
    }

    public String getSsid() {
        return this.ssid;
    }

    public String getPortname() {
        return this.portname;
    }

    public String getNetinterface() {
        return this.netinterface;
    }
}

