/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities.readers;

import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfig;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfigMulticast;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfigUnicast;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowTemplate;
import com.excentis.products.byteblower.results.testdata.data.entities.FbSource;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.AbstractFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowTemplateReader;
import com.excentis.products.byteblower.results.testdata.data.enums.PortStatus;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class FbFlowInstanceReader
extends AbstractFlowInstanceReader<FbFlowInstance> {
    FbFlowInstanceReader(FbFlowInstance entity) {
        super(entity);
    }

    public FbSource getSource() {
        return ((FbFlowInstance)this.entity).getSource();
    }

    public FbFlowTemplateReader getFlowTemplateReader() {
        return EntityReaderFactory.create(this.getFlowTemplate());
    }

    private FbFlowTemplate getFlowTemplate() {
        return ((FbFlowInstance)this.entity).getFlowTemplate();
    }

    public Set<FbDestination> getDestinations() {
        HashSet<FbDestination> destinations = new HashSet<FbDestination>();
        FbDestinationConfig fbDestinationConfig = ((FbFlowInstance)this.entity).getDestinationConfig();
        if (fbDestinationConfig instanceof FbDestinationConfigUnicast) {
            destinations.add(((FbDestinationConfigUnicast)fbDestinationConfig).getDestination());
        } else if (fbDestinationConfig instanceof FbDestinationConfigMulticast) {
            destinations.addAll(((FbDestinationConfigMulticast)fbDestinationConfig).getDestinations());
        }
        return destinations;
    }

    public Set<FbDestination> getDestinationsActive() {
        HashSet<FbDestination> destinationsActive = new HashSet<FbDestination>();
        for (FbDestination fbDestination : this.getDestinations()) {
            if (fbDestination.getPort().getStatus() != PortStatus.ACTIVE) continue;
            destinationsActive.add(fbDestination);
        }
        return destinationsActive;
    }

    public Set<FbDestination> getDestinationsConfigured() {
        HashSet<FbDestination> destinationsConfigured = new HashSet<FbDestination>();
        for (FbDestination fbDestination : this.getDestinations()) {
            if (!EntityReaderFactory.create(fbDestination.getPort()).isConfigured()) continue;
            destinationsConfigured.add(fbDestination);
        }
        return destinationsConfigured;
    }

    public Set<FbDestination> getEavesdroppers() {
        if (((FbFlowInstance)this.getEntity()).getDestinationConfig() == null) {
            return Collections.emptySet();
        }
        return ((FbFlowInstance)this.getEntity()).getDestinationConfig().getEavesdroppers();
    }

    public Set<FbDestination> getEavesdroppersActive() {
        HashSet<FbDestination> eavesdroppersActive = new HashSet<FbDestination>();
        for (FbDestination fbEavesdropper : this.getEavesdroppers()) {
            if (fbEavesdropper.getPort().getStatus() != PortStatus.ACTIVE) continue;
            eavesdroppersActive.add(fbEavesdropper);
        }
        return eavesdroppersActive;
    }

    public Set<FbDestination> getEavesdroppersConfigured() {
        HashSet<FbDestination> eavesdroppersConfigured = new HashSet<FbDestination>();
        for (FbDestination fbEavesdropper : this.getEavesdroppers()) {
            if (!EntityReaderFactory.create(fbEavesdropper.getPort()).isConfigured()) continue;
            eavesdroppersConfigured.add(fbEavesdropper);
        }
        return eavesdroppersConfigured;
    }

    public Set<FbDestination> getDestinationsAndEavesdroppers() {
        HashSet<FbDestination> destinationsAndEavesdroppers = new HashSet<FbDestination>();
        destinationsAndEavesdroppers.addAll(this.getDestinations());
        destinationsAndEavesdroppers.addAll(this.getEavesdroppers());
        return destinationsAndEavesdroppers;
    }

    public Set<FbDestination> getDestinationsAndEavesdroppersActive() {
        HashSet<FbDestination> destinationsAndEavesdroppersActive = new HashSet<FbDestination>();
        destinationsAndEavesdroppersActive.addAll(this.getDestinationsActive());
        destinationsAndEavesdroppersActive.addAll(this.getEavesdroppersActive());
        return destinationsAndEavesdroppersActive;
    }

    public Set<FbDestination> getDestinationsAndEavesdroppersConfigured() {
        HashSet<FbDestination> destinationsAndEavesdroppersConfigured = new HashSet<FbDestination>();
        destinationsAndEavesdroppersConfigured.addAll(this.getDestinationsConfigured());
        destinationsAndEavesdroppersConfigured.addAll(this.getEavesdroppersConfigured());
        return destinationsAndEavesdroppersConfigured;
    }

    public String getStart() {
        Long nanos = ((FbFlowInstance)this.entity).getStartTime();
        HighResolutionCalendar start = new HighResolutionCalendar(nanos);
        return HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)start);
    }

    public String getDuration() {
        Long duration = ((FbFlowInstance)this.entity).getDuration();
        HighResolutionCalendar calendarDuration = new HighResolutionCalendar(duration);
        return HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)calendarDuration);
    }
}

