/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities.readers;

import com.excentis.products.byteblower.results.testdata.data.entities.FbTriggerSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.core.BaseEntityReader;
import com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit;
import com.excentis.products.byteblower.results.testdata.data.utils.EthernetThroughputType;
import com.excentis.products.byteblower.results.testdata.data.utils.EthernetThroughputUtility;
import com.excentis.products.byteblower.results.testdata.data.utils.ThroughputReader;
import com.excentis.products.byteblower.results.testdata.data.utils.UnitReader;

public final class FbTriggerSnapshotReader
extends BaseEntityReader<FbTriggerSnapshot> {
    FbTriggerSnapshotReader(FbTriggerSnapshot entity) {
        super(entity);
    }

    public Double getThroughput(EthernetThroughputType throughputType, DataRateUnit dataRateUnit) {
        return this.isZero() ? FbTriggerSnapshotReader.zeroValue() : ThroughputReader.convertThroughput(this.getThroughputBps(throughputType), DataRateUnit.BIT_PER_SECOND, dataRateUnit);
    }

    public Double getThroughputBps(EthernetThroughputType throughputType) {
        if (this.isZero()) {
            return FbTriggerSnapshotReader.zeroValue();
        }
        Double durationSeconds = this.getSnapshotDurationSeconds();
        if (durationSeconds == null) {
            return null;
        }
        return EthernetThroughputUtility.calculateThroughputBitsPerSecond(((FbTriggerSnapshot)this.entity).getByteCount(), ((FbTriggerSnapshot)this.entity).getPacketCount(), throughputType, durationSeconds);
    }

    public Double getFrameRate() {
        if (this.isZero()) {
            return FbTriggerSnapshotReader.zeroValue();
        }
        Double durationSeconds = this.getSnapshotDurationSeconds();
        if (durationSeconds == null) {
            return null;
        }
        return (double)((FbTriggerSnapshot)this.entity).getPacketCount().longValue() / durationSeconds;
    }

    public Long getSnapshotDurationNs() {
        return ((FbTriggerSnapshot)this.entity).getSnapshotDuration();
    }

    public Double getSnapshotDurationSeconds() {
        if (((FbTriggerSnapshot)this.entity).getSnapshotDuration() == 0L) {
            return null;
        }
        return UnitReader.convert((double)((FbTriggerSnapshot)this.entity).getSnapshotDuration(), UnitReader.UnitPrefix.NANO, UnitReader.UnitPrefix.BASE);
    }

    public Long getSnapshotTimeNs() {
        return ((FbTriggerSnapshot)this.entity).getSnapshotTime();
    }

    public Long getSnapshotTimeMs() {
        return Math.round(UnitReader.convert(this.getSnapshotTimeNs(), UnitReader.UnitPrefix.NANO, UnitReader.UnitPrefix.MILLI));
    }

    public Long getCorrectedSnapshotTimeMs() {
        long ms = this.getSnapshotTimeMs();
        ms = this.timeZoneOffset(ms);
        return ms;
    }
}

