/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities.readers;

import com.excentis.products.byteblower.results.testdata.data.entities.HttpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.core.BaseEntityReader;
import com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit;
import com.excentis.products.byteblower.results.testdata.data.utils.ThroughputReader;
import com.excentis.products.byteblower.results.testdata.data.utils.UnitReader;
import java.util.Date;

public class HttpSessionSnapshotReader
extends BaseEntityReader<HttpSessionSnapshot> {
    HttpSessionSnapshotReader(HttpSessionSnapshot entity) {
        super(entity);
    }

    public Double getTxThroughput(DataRateUnit dataRateUnit) {
        return this.isZero() ? HttpSessionSnapshotReader.zeroValue() : ThroughputReader.convertThroughput(this.getTxThroughputBps(), DataRateUnit.BIT_PER_SECOND, dataRateUnit);
    }

    public Double getRxThroughput(DataRateUnit dataRateUnit) {
        return this.isZero() ? HttpSessionSnapshotReader.zeroValue() : ThroughputReader.convertThroughput(this.getRxThroughputBps(), DataRateUnit.BIT_PER_SECOND, dataRateUnit);
    }

    public Double getTxThroughputBps() {
        if (this.isZero()) {
            return HttpSessionSnapshotReader.zeroValue();
        }
        Double durationSeconds = this.getSnapshotDurationSeconds();
        if (durationSeconds == null || durationSeconds == 0.0) {
            return null;
        }
        Double val = ThroughputReader.convertBytesToBits((double)((HttpSessionSnapshot)this.entity).getTxByteCount()) / durationSeconds;
        return val;
    }

    public Double getRxThroughputBps() {
        if (this.isZero()) {
            return HttpSessionSnapshotReader.zeroValue();
        }
        Double durationSeconds = this.getSnapshotDurationSeconds();
        if (durationSeconds == null || durationSeconds == 0.0) {
            return null;
        }
        Double val = ThroughputReader.convertBytesToBits((double)((HttpSessionSnapshot)this.entity).getRxByteCount()) / durationSeconds;
        return val;
    }

    public Long getSnapshotDurationNs() {
        return ((HttpSessionSnapshot)this.entity).getSnapshotDuration();
    }

    public Double getSnapshotDurationSeconds() {
        if (((HttpSessionSnapshot)this.entity).getSnapshotDuration() == 0L) {
            return null;
        }
        return UnitReader.convert((double)((HttpSessionSnapshot)this.entity).getSnapshotDuration(), UnitReader.UnitPrefix.NANO, UnitReader.UnitPrefix.BASE);
    }

    public Long getSnapshotTimeNs() {
        return ((HttpSessionSnapshot)this.entity).getSnapshotTime();
    }

    public Date getSnapshotTime() {
        Long ms = this.getSnapshotTimeMs();
        return new Date(ms);
    }

    public Long getSnapshotTimeMs() {
        Long snapshotNs = this.getSnapshotTimeNs();
        long ms = Math.round(UnitReader.convert(snapshotNs, UnitReader.UnitPrefix.NANO, UnitReader.UnitPrefix.MILLI));
        return ms;
    }

    public Long getCorrectedSnapshotTimeMs() {
        Long ms = this.getSnapshotTimeMs();
        ms = this.timeZoneOffset(ms);
        return ms;
    }
}

