/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities.readers;

import com.excentis.products.byteblower.results.testdata.data.entities.readers.QueryWithEntityManager;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Parameter;
import jakarta.persistence.TypedQuery;
import java.util.AbstractList;
import java.util.List;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class PagingList<X>
extends AbstractList<X> {
    private int size;
    private int pageSize;
    private TypedQuery<X> query;
    private int currentPageNumber = -1;
    private List<X> currentPage = null;
    private String seriesName;
    private EntityManager entityManager;

    public PagingList(EntityManager entityManager, String seriesName, TypedQuery<X> query, int pageSize) {
        this.entityManager = entityManager;
        this.seriesName = seriesName;
        this.query = query;
        this.pageSize = pageSize;
        this.size = this.calculateSize();
    }

    public String getSeries() {
        return this.seriesName;
    }

    @Override
    public X get(int index) {
        int currentPage = index / this.pageSize;
        int pageIndex = index % this.pageSize;
        List<X> page = this.getPage(currentPage);
        return page.get(pageIndex);
    }

    @Override
    public int size() {
        return this.size;
    }

    private void evictCache() {
        if (this.currentPage != null) {
            for (X o : this.currentPage) {
                this.entityManager.detach(o);
            }
            this.currentPage.clear();
        }
    }

    public void clearBuffers() {
        this.evictCache();
        this.currentPageNumber = -1;
    }

    protected void finalize() throws Throwable {
        this.evictCache();
    }

    protected List<X> getPage(int pageNumber) {
        if (pageNumber != this.currentPageNumber) {
            this.evictCache();
            this.query.setFirstResult(this.pageSize * pageNumber);
            this.query.setMaxResults(this.pageSize);
            this.currentPage = this.query.getResultList();
            this.currentPageNumber = pageNumber;
        }
        return this.currentPage;
    }

    private int calculateSize() {
        if (this.query == null) {
            return 0;
        }
        EntityManager manager = null;
        if (this.query instanceof QueryWithEntityManager) {
            manager = ((QueryWithEntityManager)this.query).getEntityManager();
            return (int)this.query.getResultStream().count();
        }
        if (!(this.query instanceof JpaQuery)) {
            throw new RuntimeException("Unknown Query type.. Can't compute resultsize");
        }
        JpaQuery queryImpl = (JpaQuery)this.query;
        manager = queryImpl.getEntityManager();
        ReadAllQuery raq = JpaHelper.getReadAllQuery(this.query);
        ReportQuery rq = null;
        if (raq.isReportQuery()) {
            rq = (ReportQuery)raq.clone();
            rq.getItems().clear();
            rq.addCount();
            rq.getGroupByExpressions().clear();
            rq.getOrderByExpressions().clear();
        } else {
            rq = new ReportQuery();
            rq.setReferenceClass(raq.getReferenceClass());
            rq.addCount();
            rq.setShouldReturnSingleValue(true);
            rq.setSelectionCriteria(raq.getSelectionCriteria());
        }
        TypedQuery countQuery = (TypedQuery)JpaHelper.createQuery((DatabaseQuery)rq, (EntityManager)this.entityManager);
        for (Parameter p : this.query.getParameters()) {
            Object paramValue = this.query.getParameterValue(p);
            countQuery.setParameter(p.getName(), paramValue);
        }
        return ((Number)countQuery.getSingleResult()).intValue();
    }
}

