/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities.readers;

import com.excentis.products.byteblower.results.testdata.data.entities.Interface;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4Address;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4NatConfiguration;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv6Address;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer2;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer25;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer25Vlan;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer2EthernetII;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4Session;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6Session;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6SessionAddress;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6SessionGateway;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6SessionPrefix;
import com.excentis.products.byteblower.results.testdata.data.entities.MacAddress;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.Server;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.core.BaseEntityReader;
import com.excentis.products.byteblower.results.testdata.data.enums.PortStatus;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv4AddressUtility;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv6AddressUtility;
import com.excentis.products.byteblower.results.testdata.data.utils.MacAddressUtility;
import java.util.ArrayList;
import java.util.List;

public class PortReader
extends BaseEntityReader<Port> {
    PortReader(Port entity) {
        super(entity);
    }

    public boolean isConfigurationFailed() {
        PortStatus status = ((Port)this.entity).getStatus();
        return status == PortStatus.CONFIGURATION_ERROR;
    }

    public boolean isConfigured() {
        PortStatus status = ((Port)this.entity).getStatus();
        return status == PortStatus.ACTIVE || status == PortStatus.STOPPED;
    }

    public boolean isNatted() {
        Layer3 layer3 = ((Port)this.entity).getLayer3();
        if (layer3 instanceof Layer3Ipv4) {
            Layer3Ipv4 layer3Ipv4 = (Layer3Ipv4)((Port)this.entity).getLayer3();
            Ipv4NatConfiguration natConfig = layer3Ipv4.getNatConfiguration();
            return natConfig != null;
        }
        return false;
    }

    public String getName() {
        return ((Port)this.entity).getName();
    }

    private Layer3 getLayer3() {
        return ((Port)this.entity).getLayer3();
    }

    private Layer3Ipv4 getIPv4() {
        Layer3 layer3 = this.getLayer3();
        if (layer3 instanceof Layer3Ipv4) {
            return (Layer3Ipv4)this.getLayer3();
        }
        return null;
    }

    public boolean isIPv4() {
        return this.getIPv4() != null;
    }

    private Layer3Ipv4Session getIPv4Session() {
        if (!this.isIPv4()) {
            return null;
        }
        return this.getIPv4().getSession();
    }

    public String getIPv4Address() {
        if (!this.isIPv4()) {
            return null;
        }
        Layer3Ipv4Session session = this.getIPv4Session();
        if (session == null) {
            return null;
        }
        return this.toString(session.getAddress());
    }

    public String getIPv4Gateway() {
        Ipv4Address gateway = null;
        if (!this.isIPv4()) {
            return null;
        }
        Layer3Ipv4Session session = this.getIPv4Session();
        if (session == null) {
            return null;
        }
        gateway = session.getGatewayAddress();
        if (gateway == null || !gateway.isValid()) {
            return null;
        }
        return this.toString(gateway);
    }

    public String getIpv4Netmask() {
        if (!this.isIPv4()) {
            return null;
        }
        Layer3Ipv4Session session = this.getIPv4Session();
        if (session == null) {
            return null;
        }
        Integer netmask = session.getNetmask();
        if (netmask == null || netmask == 0) {
            return null;
        }
        return Ipv4AddressUtility.convertPrefixLengthToIpv4Netmask(netmask);
    }

    private Layer3Ipv6 getIPv6() {
        Layer3 layer3 = this.getLayer3();
        if (layer3 instanceof Layer3Ipv6) {
            return (Layer3Ipv6)this.getLayer3();
        }
        return null;
    }

    public boolean isIPv6() {
        return this.getIPv6() != null;
    }

    private Layer3Ipv6Session getIPv6Session() {
        if (!this.isIPv6()) {
            return null;
        }
        return this.getIPv6().getSession();
    }

    public String getIPv6AddressFirstPublic() {
        if (!this.isIPv6()) {
            return null;
        }
        Layer3Ipv6Session session = this.getIPv6Session();
        if (session == null) {
            return null;
        }
        for (Layer3Ipv6SessionPrefix prefix : this.getIPv6().getSession().getPrefixes()) {
            if (prefix.getAddresses().isEmpty()) continue;
            return this.toString(prefix.getAddresses().iterator().next().getIpv6Address());
        }
        return null;
    }

    public String getIPv6PrefixLengthFirstPublic() {
        if (!this.isIPv6()) {
            return null;
        }
        Layer3Ipv6Session session = this.getIPv6Session();
        if (session == null) {
            return null;
        }
        for (Layer3Ipv6SessionPrefix prefix : this.getIPv6().getSession().getPrefixes()) {
            if (prefix.getAddresses().isEmpty()) continue;
            return "" + prefix.getPrefixLength();
        }
        return null;
    }

    public String getIPv6GatewayFirst() {
        Ipv6Address address;
        if (!this.isIPv6()) {
            return null;
        }
        Layer3Ipv6Session session = this.getIPv6Session();
        if (session == null) {
            return null;
        }
        if (!session.getGatewayAddresses().isEmpty() && Ipv6AddressUtility.isValid(address = session.getGatewayAddresses().iterator().next().getIpv6Address())) {
            return this.toString(session.getGatewayAddresses().iterator().next().getIpv6Address());
        }
        return null;
    }

    public String getNat() {
        Layer3Ipv4 layer3Ipv4;
        Ipv4NatConfiguration config;
        Layer3 layer3 = ((Port)this.entity).getLayer3();
        if (layer3 instanceof Layer3Ipv4 && (config = (layer3Ipv4 = (Layer3Ipv4)((Port)this.entity).getLayer3()).getNatConfiguration()) != null) {
            return config.name();
        }
        return "No";
    }

    public List<Integer> getVlanIds() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        Layer2 layer2 = ((Port)this.entity).getLayer2();
        if (layer2 != null) {
            List<Layer25> layers25 = layer2.getLayer25List();
            for (Layer25 layer : layers25) {
                if (!(layer instanceof Layer25Vlan)) continue;
                Layer25Vlan vlan = (Layer25Vlan)layer;
                int id = vlan.getVlanConfiguration().getVlan();
                ids.add(id);
            }
        }
        return ids;
    }

    public String getVlan() {
        Layer2 layer2 = ((Port)this.entity).getLayer2();
        if (layer2 == null) {
            return "";
        }
        List<Layer25> layers25 = layer2.getLayer25List();
        if (!layers25.isEmpty()) {
            String description = "";
            int vlanCounter = 0;
            int vlanSize = layers25.size();
            for (Layer25 layer : layers25) {
                if (!(layer instanceof Layer25Vlan)) continue;
                Layer25Vlan vlan = (Layer25Vlan)layer;
                int id = vlan.getVlanConfiguration().getVlan();
                description = vlanCounter == 0 ? String.valueOf(description) + id : (1 == vlanCounter ? String.valueOf(description) + " (outer), " + id : (vlanSize == vlanCounter + 1 ? String.valueOf(description) + ", " + id + " (inner)" : String.valueOf(description) + ", " + id));
                ++vlanCounter;
            }
            return description;
        }
        return "No";
    }

    public Integer getMtu() {
        return ((Port)this.entity).getMtu();
    }

    public String getMac() {
        Layer2 layer2 = ((Port)this.entity).getLayer2();
        if (layer2 == null) {
            return "Layer 2 Address Unknown";
        }
        if (layer2 instanceof Layer2EthernetII) {
            Layer2EthernetII ethII = (Layer2EthernetII)layer2;
            return this.toString(ethII.getMacAddress());
        }
        return "Unsupported Layer2 Type";
    }

    private String toString(MacAddress address) {
        if (address == null) {
            return null;
        }
        return MacAddressUtility.convertFromBinary(address.getAddress());
    }

    private String toString(Ipv4Address address) {
        if (address == null) {
            return null;
        }
        return Ipv4AddressUtility.convertToString(address.getAddress());
    }

    private String toString(Ipv6Address address) {
        if (address == null) {
            return null;
        }
        return Ipv6AddressUtility.convertToExpandedString(address.getAddress());
    }

    public String getDocked() {
        return ((Port)this.entity).getDocked();
    }

    public String getServerVersion() {
        String INVALID_VERSION = "0.0.0";
        Interface serverInterface = ((Port)this.entity).getInterface();
        if (serverInterface == null) {
            return "0.0.0";
        }
        Server server = serverInterface.getServer();
        if (server == null) {
            return "0.0.0";
        }
        return server.getVersion();
    }

    public String getLinkLocalAddress() {
        if (!this.isIPv6()) {
            return null;
        }
        Layer3Ipv6Session session = this.getIPv6Session();
        if (session == null) {
            return null;
        }
        return this.toString(session.getLinkLocalAddress());
    }

    public List<String> getIPv6Addresses() {
        ArrayList<String> addresses = new ArrayList<String>();
        if (!this.isIPv6()) {
            return null;
        }
        Layer3Ipv6Session session = this.getIPv6Session();
        if (session == null) {
            return null;
        }
        for (Layer3Ipv6SessionPrefix prefix : session.getPrefixes()) {
            for (Layer3Ipv6SessionAddress address : prefix.getAddresses()) {
                addresses.add(this.toString(address.getIpv6Address()));
            }
        }
        return addresses;
    }

    public List<String> getIPv6Gateways() {
        ArrayList<String> gateways = new ArrayList<String>();
        if (!this.isIPv6()) {
            return null;
        }
        Layer3Ipv6Session session = this.getIPv6Session();
        if (session == null) {
            return null;
        }
        for (Layer3Ipv6SessionGateway gw : session.getGatewayAddresses()) {
            Ipv6Address address = gw.getIpv6Address();
            if (!Ipv6AddressUtility.isValid(address)) continue;
            gateways.add(this.toString(address));
        }
        return gateways;
    }

    public List<Integer> getIPv6PrefixLengths() {
        ArrayList<Integer> prefixes = new ArrayList<Integer>();
        if (!this.isIPv6()) {
            return null;
        }
        Layer3Ipv6Session session = this.getIPv6Session();
        if (session == null) {
            return null;
        }
        for (Layer3Ipv6SessionPrefix prefix : session.getPrefixes()) {
            for (Layer3Ipv6SessionAddress address : prefix.getAddresses()) {
                prefixes.add(prefix.getPrefixLength());
            }
        }
        return prefixes;
    }
}

