/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.utils;

import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceConversionError;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv6Address;
import com.googlecode.ipv6.IPv6Address;
import com.googlecode.ipv6.IPv6Network;
import com.googlecode.ipv6.IPv6NetworkMask;
import java.util.Arrays;
import java.util.regex.Pattern;

public class Ipv6AddressUtility {
    private Ipv6AddressUtility() {
    }

    public static String extractIpv6AddressFromPrefixedIpv6Address(String ipv6AddressWithPrefix) throws TestDataPersistenceConversionError {
        String[] parts = Pattern.compile("/").split(ipv6AddressWithPrefix);
        if (parts.length != 2) {
            throw new TestDataPersistenceConversionError("Cannot extract address from prefixed-address; (address was not of format <address>/<prefix>) " + ipv6AddressWithPrefix);
        }
        return parts[0];
    }

    public static Integer extractPrefixLengthFromPrefixedIpv6Address(String ipv6AddressWithPrefix) throws TestDataPersistenceConversionError {
        Integer prefixLength;
        String[] parts = Pattern.compile("/").split(ipv6AddressWithPrefix);
        if (parts.length != 2) {
            throw new TestDataPersistenceConversionError("Cannot extract prefix length from prefixed address; (address was not of format <address>/<prefix>) " + ipv6AddressWithPrefix);
        }
        try {
            prefixLength = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException ex) {
            throw new TestDataPersistenceConversionError("Cannot extract prefix length from prefixed address; (prefix part was not a valid number) " + ipv6AddressWithPrefix);
        }
        return prefixLength;
    }

    public static byte[] convertToBinary(String ipv6Address) throws TestDataPersistenceConversionError {
        try {
            IPv6Address address = IPv6Address.fromString((String)ipv6Address);
            return address.toByteArray();
        }
        catch (IllegalArgumentException ex) {
            throw new TestDataPersistenceConversionError("Cannot convert invalid IPv6 address " + ipv6Address + "to binary", ex);
        }
    }

    public static String convertToCanonicalizedString(byte[] ipv6Address) throws TestDataPersistenceConversionError {
        try {
            IPv6Address address = IPv6Address.fromByteArray((byte[])ipv6Address);
            return address.toString();
        }
        catch (IllegalArgumentException ex) {
            throw new TestDataPersistenceConversionError("Cannot convert invalid IPv6 address bytes '" + ipv6Address + "' to string", ex);
        }
    }

    public static String convertToExpandedString(byte[] ipv6Address) throws TestDataPersistenceConversionError {
        return Ipv6AddressUtility.expandIpv6Address(Ipv6AddressUtility.convertToCanonicalizedString(ipv6Address));
    }

    public static String canonicalizeIpv6Address(String ipv6Address) throws TestDataPersistenceConversionError {
        try {
            IPv6Address address = IPv6Address.fromString((String)ipv6Address);
            return address.toString();
        }
        catch (IllegalArgumentException ex) {
            throw new TestDataPersistenceConversionError("Cannot canonicalize invalid IPv6 address" + ipv6Address, ex);
        }
    }

    public static String expandIpv6Address(String ipv6Address) throws TestDataPersistenceConversionError {
        try {
            IPv6Address address = IPv6Address.fromString((String)ipv6Address);
            return address.toLongString();
        }
        catch (IllegalArgumentException ex) {
            throw new TestDataPersistenceConversionError("Cannot expand invalid IPv6 address" + ipv6Address, ex);
        }
    }

    public static String retrieveIpv6PrefixFromIpv6Address(String ipv6Address, int prefixLength) throws TestDataPersistenceConversionError {
        try {
            IPv6Network network = IPv6Network.fromAddressAndMask((IPv6Address)IPv6Address.fromString((String)ipv6Address), (IPv6NetworkMask)IPv6NetworkMask.fromPrefixLength((int)prefixLength));
            return network.toLongString().split("/")[0];
        }
        catch (IllegalArgumentException ex) {
            throw new TestDataPersistenceConversionError("Cannot retrieve prefix from invalid IPv6 address " + ipv6Address, ex);
        }
    }

    public static String retrieveIpv6PrefixFromPrefixedIpv6Address(String ipv6AddressWithPrefix) throws TestDataPersistenceConversionError {
        return Ipv6AddressUtility.retrieveIpv6PrefixFromIpv6Address(Ipv6AddressUtility.extractIpv6AddressFromPrefixedIpv6Address(ipv6AddressWithPrefix), Ipv6AddressUtility.extractPrefixLengthFromPrefixedIpv6Address(ipv6AddressWithPrefix));
    }

    public static boolean isValid(Ipv6Address address) {
        byte[] data = address.getAddress();
        return !Arrays.equals(data, new byte[data.length]);
    }
}

