/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.utils;

import com.excentis.products.byteblower.results.testdata.data.utils.UnitReader;

public enum LatencyUnit {
    NANOSECONDS(UnitReader.UnitPrefix.NANO, "ns"),
    MICROSECONDS(UnitReader.UnitPrefix.MICRO, "\u00b5s"),
    MILLISECONDS(UnitReader.UnitPrefix.MILLI, "ms"),
    SECONDS(UnitReader.UnitPrefix.BASE, "s");

    private final UnitReader.UnitPrefix unitPrefix;
    private final String string;

    private LatencyUnit(UnitReader.UnitPrefix unitPrefix, String string2) {
        this.unitPrefix = unitPrefix;
        this.string = string2;
    }

    public UnitReader.UnitPrefix getUnitPrefix() {
        return this.unitPrefix;
    }

    public String toString() {
        return this.string;
    }

    public static Double convert(Integer value, LatencyUnit fromUnit, LatencyUnit toUnit) {
        if (value == null) {
            return null;
        }
        return UnitReader.convert((double)value, fromUnit.getUnitPrefix(), toUnit.getUnitPrefix());
    }

    public static Double convert(Long value, LatencyUnit fromUnit, LatencyUnit toUnit) {
        if (value == null) {
            return null;
        }
        return UnitReader.convert((double)value, fromUnit.getUnitPrefix(), toUnit.getUnitPrefix());
    }

    public static Double convert(Double value, LatencyUnit fromUnit, LatencyUnit toUnit) {
        if (value == null) {
            return null;
        }
        return UnitReader.convert(value, fromUnit.getUnitPrefix(), toUnit.getUnitPrefix());
    }
}

