/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.utils;

import com.excentis.products.byteblower.results.testdata.data.utils.UnitReader;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ResultsOverTimeUtility {
    public static SortedMap<Date, Double> getChartValuePointsDate(BucketChartType bucketChartType, long valueResolutionNs, List<BucketDataPoint> dataPoints, boolean dataMissingAtStart, boolean dataMissingAtEnd) {
        SortedMap<Long, Double> chartValuePointsNs = ResultsOverTimeUtility.getChartValuePointsNs(bucketChartType, valueResolutionNs, dataPoints, dataMissingAtStart, dataMissingAtEnd);
        TreeMap<Date, Double> chartValuePointsDate = new TreeMap<Date, Double>();
        for (Map.Entry<Long, Double> valuePointNsEntry : chartValuePointsNs.entrySet()) {
            chartValuePointsDate.put(new Date(Math.round(UnitReader.convert(valuePointNsEntry.getKey(), UnitReader.UnitPrefix.NANO, UnitReader.UnitPrefix.MILLI))), valuePointNsEntry.getValue());
        }
        return chartValuePointsDate;
    }

    public static SortedMap<Long, Double> getChartValuePointsNs(BucketChartType bucketChartType, long valueResolutionNs, List<BucketDataPoint> dataPoints, boolean dataMissingAtStart, boolean dataMissingAtEnd) {
        switch (bucketChartType) {
            case MIDDLE: {
                return ResultsOverTimeUtility.getChartValuePointsMiddle(valueResolutionNs, dataPoints, dataMissingAtStart, dataMissingAtEnd);
            }
        }
        throw new IllegalStateException("Unsupported chart type " + (Object)((Object)bucketChartType));
    }

    private static SortedMap<Long, Double> getChartValuePointsMiddle(long xValueResolutionNs, List<BucketDataPoint> dataPoints, boolean missingDataAtStart, boolean missingDataAtEnd) {
        long halfResolutionNs = xValueResolutionNs / 2L;
        TreeMap<Long, Double> valuePoints = new TreeMap<Long, Double>();
        if (dataPoints.isEmpty()) {
            return valuePoints;
        }
        boolean first = true;
        long lastValuePointTime = -1L;
        for (BucketDataPoint bdp : dataPoints) {
            if (bdp.getXValueBucketDurationNs() % xValueResolutionNs != 0L) {
                throw new IllegalArgumentException("Data point width should be multiple of valueResolution");
            }
            if (first && !missingDataAtStart) {
                valuePoints.put(bdp.getXValueBucketStartNs(), 0.0);
                first = false;
            }
            long timeNs = 0L;
            while (timeNs < bdp.getXValueBucketDurationNs()) {
                valuePoints.put(bdp.getXValueBucketStartNs() + timeNs + halfResolutionNs, bdp.getYValue());
                timeNs += xValueResolutionNs;
            }
            lastValuePointTime = bdp.getXValueBucketStartNs() + bdp.getXValueBucketDurationNs() - halfResolutionNs;
        }
        if (!missingDataAtEnd) {
            valuePoints.put(lastValuePointTime + halfResolutionNs, 0.0);
        }
        return valuePoints;
    }

    public static enum BucketChartType {
        MIDDLE,
        BLOCK;

    }

    public static class BucketDataPoint {
        private double yValue;
        private long xValueBucketStart;
        private long xValueBucketWidth;

        public BucketDataPoint(double yVal, long xValBucketStart, long xValBucketWidth) {
            this.yValue = yVal;
            this.xValueBucketStart = xValBucketStart;
            this.xValueBucketWidth = xValBucketWidth;
        }

        public double getYValue() {
            return this.yValue;
        }

        public long getXValueBucketStartNs() {
            return this.xValueBucketStart;
        }

        public long getXValueBucketDurationNs() {
            return this.xValueBucketWidth;
        }

        public String toString() {
            return String.valueOf(this.xValueBucketStart) + "|->" + this.xValueBucketWidth + " => " + this.yValue;
        }
    }
}

