/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.utils;

import com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit;
import com.excentis.products.byteblower.results.testdata.data.utils.UnitReader;

public class ThroughputReader
extends UnitReader {
    public static final Double BITS_PER_BYTE = new Double(8.0);
    public static final Double NANOSECONDS_IN_SECOND = new Double(1.0E9);

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$results$testdata$data$utils$DataRateUnit = ThroughputReader.$SWITCH_TABLE$com$excentis$products$byteblower$results$testdata$data$utils$DataRateUnit();
    }

    public static Double convertThroughput(Double throughput, DataRateUnit fromUnit, DataRateUnit toUnit) {
        if (fromUnit == toUnit) {
            return throughput;
        }
        if (throughput == null) {
            return null;
        }
        UnitReader.UnitPrefix fromPrefix = ThroughputReader.getUnitPrefix(fromUnit);
        UnitReader.UnitPrefix toPrefix = ThroughputReader.getUnitPrefix(toUnit);
        throughput = ThroughputReader.convert(throughput, fromPrefix, toPrefix);
        if (ThroughputReader.usesBytes(fromUnit) != ThroughputReader.usesBytes(toUnit)) {
            throughput = ThroughputReader.usesBytes(toUnit) ? ThroughputReader.convertBitsToBytes(throughput) : ThroughputReader.convertBytesToBits(throughput);
        }
        return throughput;
    }

    public static Double convertBitsToBytes(Double throughput) {
        return throughput / BITS_PER_BYTE;
    }

    public static Double convertBytesToBits(Double throughput) {
        return throughput * BITS_PER_BYTE;
    }

    public static Double convertFrom(Double value, DataRateUnit fromUnit) {
        if (value == null) {
            return null;
        }
        UnitReader.UnitPrefix fromPrefix = ThroughputReader.getUnitPrefix(fromUnit);
        switch (fromUnit) {
            case BYTE_PER_SECOND: 
            case KILOBYTE_PER_SECOND: 
            case MEGABYTE_PER_SECOND: 
            case GIGABYTE_PER_SECOND: {
                value = ThroughputReader.convertBytesToBits(value);
                break;
            }
        }
        return ThroughputReader.convertFrom(value, fromPrefix);
    }

    public static Double convertTo(Double value, DataRateUnit toUnit) {
        if (value == null) {
            return null;
        }
        UnitReader.UnitPrefix toPrefix = ThroughputReader.getUnitPrefix(toUnit);
        switch (toUnit) {
            case BYTE_PER_SECOND: 
            case KILOBYTE_PER_SECOND: 
            case MEGABYTE_PER_SECOND: 
            case GIGABYTE_PER_SECOND: {
                value = ThroughputReader.convertBitsToBytes(value);
                break;
            }
        }
        return ThroughputReader.convertTo(value, toPrefix);
    }

    private static UnitReader.UnitPrefix getUnitPrefix(DataRateUnit unit) {
        switch (unit) {
            case BIT_PER_SECOND: 
            case BYTE_PER_SECOND: {
                return UnitReader.UnitPrefix.BASE;
            }
            case KILOBIT_PER_SECOND: 
            case KILOBYTE_PER_SECOND: {
                return UnitReader.UnitPrefix.KILO;
            }
            case MEGABIT_PER_SECOND: 
            case MEGABYTE_PER_SECOND: {
                return UnitReader.UnitPrefix.MEGA;
            }
            case GIGABIT_PER_SECOND: 
            case GIGABYTE_PER_SECOND: {
                return UnitReader.UnitPrefix.GIGA;
            }
        }
        System.err.println("ThroughputReader::getUnitPrefix : unsupported unit : " + (Object)((Object)unit));
        return null;
    }

    private static boolean usesBytes(DataRateUnit unit) {
        return unit == DataRateUnit.BYTE_PER_SECOND || unit == DataRateUnit.KILOBYTE_PER_SECOND || unit == DataRateUnit.MEGABYTE_PER_SECOND || unit == DataRateUnit.GIGABYTE_PER_SECOND;
    }
}

