/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.utils;

public class UnitReader {
    public static final double zero = 0.0;
    public static final double one = 1.0;
    public static final double thousand = 1000.0;
    public static final double million = 1000000.0;
    public static final double billion = 1.0E9;

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$results$testdata$data$utils$UnitReader$UnitPrefix = UnitReader.$SWITCH_TABLE$com$excentis$products$byteblower$results$testdata$data$utils$UnitReader$UnitPrefix();
    }

    public static Double convert(Integer value, UnitPrefix fromUnit, UnitPrefix toUnit) {
        if (value == null) {
            return null;
        }
        return UnitReader.convert((double)value, fromUnit, toUnit);
    }

    public static Double convert(Long value, UnitPrefix fromUnit, UnitPrefix toUnit) {
        if (value == null) {
            return null;
        }
        return UnitReader.convert((double)value, fromUnit, toUnit);
    }

    public static Double convert(Double value, UnitPrefix fromUnit, UnitPrefix toUnit) {
        if (value == null) {
            return null;
        }
        value = UnitReader.convertFrom(value, fromUnit);
        value = UnitReader.convertTo(value, toUnit);
        return value;
    }

    public static Double convertFrom(Double fromUnitValue, UnitPrefix fromUnit) {
        Double baseUnitValue;
        if (fromUnitValue == null) {
            return null;
        }
        switch (fromUnit) {
            case NANO: {
                baseUnitValue = fromUnitValue / 1.0E9;
                break;
            }
            case MICRO: {
                baseUnitValue = fromUnitValue / 1000000.0;
                break;
            }
            case MILLI: {
                baseUnitValue = fromUnitValue / 1000.0;
                break;
            }
            case BASE: {
                baseUnitValue = fromUnitValue;
                break;
            }
            case KILO: {
                baseUnitValue = fromUnitValue * 1000.0;
                break;
            }
            case MEGA: {
                baseUnitValue = fromUnitValue * 1000000.0;
                break;
            }
            case GIGA: {
                baseUnitValue = fromUnitValue * 1.0E9;
                break;
            }
            default: {
                System.err.println("UnitReader::convertFrom : unsupported unit : " + (Object)((Object)fromUnit));
                return null;
            }
        }
        return baseUnitValue;
    }

    public static Double convertTo(Double baseUnitValue, UnitPrefix toUnit) {
        Double toUnitValue;
        if (baseUnitValue == null) {
            return null;
        }
        switch (toUnit) {
            case NANO: {
                toUnitValue = baseUnitValue * 1.0E9;
                break;
            }
            case MICRO: {
                toUnitValue = baseUnitValue * 1000000.0;
                break;
            }
            case MILLI: {
                toUnitValue = baseUnitValue * 1000.0;
                break;
            }
            case BASE: {
                toUnitValue = baseUnitValue;
                break;
            }
            case KILO: {
                toUnitValue = baseUnitValue / 1000.0;
                break;
            }
            case MEGA: {
                toUnitValue = baseUnitValue / 1000000.0;
                break;
            }
            case GIGA: {
                toUnitValue = baseUnitValue / 1.0E9;
                break;
            }
            default: {
                System.err.println("UnitReader::convertTo : unsupported unit : " + (Object)((Object)toUnit));
                return null;
            }
        }
        return toUnitValue;
    }

    public static enum UnitPrefix {
        NANO,
        MICRO,
        MILLI,
        BASE,
        KILO,
        MEGA,
        GIGA;

    }
}

