/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.ByteBlowerPort;
import com.excentis.products.byteblower.communication.api.HTTPClient;
import com.excentis.products.byteblower.communication.api.HTTPRequestMethod;
import com.excentis.products.byteblower.communication.api.HTTPServer;
import com.excentis.products.byteblower.communication.api.PortNumberAlreadyUsed;
import com.excentis.products.byteblower.communication.api.TechnicalError;
import com.excentis.products.byteblower.communication.api.UnsupportedFeature;
import com.excentis.products.byteblower.model.HTTPMethod;
import com.excentis.products.byteblower.model.PortForwarding;
import com.excentis.products.byteblower.model.PortForwardingProtocol;
import com.excentis.products.byteblower.model.PortMapping;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.reader.FlowMeasurementReader;
import com.excentis.products.byteblower.model.reader.TcpFlowReader;
import com.excentis.products.byteblower.run.actions.ConfigureMobileHTTP;
import com.excentis.products.byteblower.run.actions.NatDiscovery;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.actions.natdiscovery.LinkPath;
import com.excentis.products.byteblower.run.exceptions.ProtocolPortAlreadyInUse;
import com.excentis.products.byteblower.run.exceptions.RuntimeInitializationError;
import com.excentis.products.byteblower.run.exceptions.UserFriendlyInitializationError;
import com.excentis.products.byteblower.run.objects.RuntimeHttpClient;
import com.excentis.products.byteblower.run.objects.RuntimeHttpFlow;
import com.excentis.products.byteblower.run.objects.RuntimeHttpServer;
import com.excentis.products.byteblower.run.objects.RuntimeMobileHttpClient;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ConfigureFlowApplicationsHttp
extends ConcreteAction<Listener> {
    private static Logger LOGGER = Logger.getGlobal();
    private final RuntimeHttpFlow rtHttpFlow;

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$model$HTTPMethod = ConfigureFlowApplicationsHttp.$SWITCH_TABLE$com$excentis$products$byteblower$model$HTTPMethod();
    }

    public static AbstractAction create(Context context, RuntimeHttpFlow rtHttpFlow) {
        return context.decorate(new ConfigureFlowApplicationsHttp(context, rtHttpFlow));
    }

    private ConfigureFlowApplicationsHttp(Context context, RuntimeHttpFlow rtHttpFlow) {
        super(context, Listener.class);
        this.rtHttpFlow = rtHttpFlow;
    }

    @Override
    public String getDescription() {
        return "Configure applications for flow '" + this.rtHttpFlow.name() + "' (HTTP)";
    }

    @Override
    public void invokeImpl() {
        HTTPRequestMethod request;
        RuntimePort rtPortWithHttpClient;
        RuntimePort rtPortWithHttpServer;
        HTTPMethod mHttpMethod = this.rtHttpFlow.getModelHttpFlowTemplate().getHTTPMethod();
        RuntimePort flowSource = this.rtHttpFlow.getSourceRuntimePort();
        RuntimePort flowDestination = this.rtHttpFlow.getRuntimeDestinationPort();
        switch (mHttpMethod) {
            case GET: {
                rtPortWithHttpServer = flowSource;
                rtPortWithHttpClient = flowDestination;
                request = HTTPRequestMethod.Get;
                break;
            }
            case PUT: {
                rtPortWithHttpServer = flowDestination;
                rtPortWithHttpClient = flowSource;
                request = HTTPRequestMethod.Put;
                break;
            }
            default: {
                if (flowSource.isMobile() && flowDestination.isMobile()) {
                    throw new IllegalStateException("Can't create TCP traffic between mobile ports. Impossible configuration");
                }
                if (flowSource.isMobile()) {
                    rtPortWithHttpServer = flowDestination;
                    rtPortWithHttpClient = flowSource;
                    request = HTTPRequestMethod.Put;
                    break;
                }
                if (flowDestination.isMobile()) {
                    rtPortWithHttpServer = flowSource;
                    rtPortWithHttpClient = flowDestination;
                    request = HTTPRequestMethod.Get;
                    break;
                }
                if (flowSource.getModelPort().isNatted() && !flowDestination.getModelPort().isNatted()) {
                    rtPortWithHttpServer = flowDestination;
                    rtPortWithHttpClient = flowSource;
                    request = HTTPRequestMethod.Put;
                    break;
                }
                if (!flowSource.getModelPort().isNatted() && flowDestination.getModelPort().isNatted()) {
                    rtPortWithHttpServer = flowSource;
                    rtPortWithHttpClient = flowDestination;
                    request = HTTPRequestMethod.Get;
                    break;
                }
                if (this.testHttpGet(flowSource, flowDestination, HTTPRequestMethod.Get, this.rtHttpFlow.isTcpPragueEnabled())) {
                    rtPortWithHttpServer = flowSource;
                    rtPortWithHttpClient = flowDestination;
                    request = HTTPRequestMethod.Get;
                    break;
                }
                if (this.testHttpGet(flowDestination, flowSource, HTTPRequestMethod.Put, this.rtHttpFlow.isTcpPragueEnabled())) {
                    rtPortWithHttpServer = flowDestination;
                    rtPortWithHttpClient = flowSource;
                    request = HTTPRequestMethod.Put;
                    break;
                }
                rtPortWithHttpServer = flowSource;
                rtPortWithHttpClient = flowDestination;
                request = HTTPRequestMethod.Get;
            }
        }
        if (rtPortWithHttpServer.isMobile()) {
            throw new IllegalStateException("A mobile port can't be server. Impossible configuration");
        }
        RuntimeHttpServer rtHttpServer = this.findOrCreateHttpServer(this.rtHttpFlow, rtPortWithHttpServer);
        RuntimeHttpClient rtHttpClient = rtPortWithHttpClient.isMobile() ? this.createMobile(this.rtHttpFlow, rtPortWithHttpClient, rtHttpServer, request) : this.createHttpClient(this.rtHttpFlow, rtPortWithHttpClient, rtHttpServer, request);
        this.rtHttpFlow.setFlowHttpApplications(rtHttpServer, rtHttpClient);
    }

    private boolean testHttpGet(RuntimePort serverPort, RuntimePort clientPort, HTTPRequestMethod direction, boolean enablePrague) {
        if (serverPort.isMobile() || clientPort.isMobile()) {
            return false;
        }
        ByteBlowerPort srcApi = serverPort.getApiPort();
        HTTPServer server = srcApi.ProtocolHttpServerAdd();
        String serverAddres = serverPort.getIPAddress();
        server.ReceiveWindowScalingEnable(false);
        try {
            server.TcpPragueEnable(enablePrague);
        }
        catch (TechnicalError | UnsupportedFeature ex) {
            LOGGER.log(Level.INFO, "Server does not support TcpPrague", ex);
        }
        ByteBlowerPort destApi = clientPort.getApiPort();
        HTTPClient client = destApi.ProtocolHttpClientAdd();
        server.Start();
        client.HttpMethodSet(direction);
        client.RequestDurationSet(1000L);
        client.RemotePortSet(server.PortGet());
        client.RemoteAddressSet(serverAddres);
        client.ReceiveWindowScalingEnable(false);
        try {
            client.TcpPragueEnable(enablePrague);
        }
        catch (TechnicalError | UnsupportedFeature ex) {
            LOGGER.log(Level.INFO, "Client does not support TcpPrague", ex);
        }
        client.RequestStart();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        int connected = server.ClientIdentifiersGet().size();
        server.Stop();
        client.ScheduleStop();
        client.RequestStop();
        srcApi.ProtocolHttpServerRemove(server);
        destApi.ProtocolHttpClientRemove(client);
        return connected > 0;
    }

    private RuntimeHttpClient createMobile(RuntimeHttpFlow rtHttpFlow, RuntimePort sourceRuntimePort, RuntimeHttpServer server, HTTPRequestMethod request) {
        RuntimeMobileHttpClient client = new RuntimeMobileHttpClient(sourceRuntimePort, server, rtHttpFlow, request);
        AbstractAction ac = ConfigureMobileHTTP.create(this.getContext(), rtHttpFlow, client, server, request);
        rtHttpFlow.addMobileConfig(ac);
        return client;
    }

    private RuntimeHttpServer findOrCreateHttpServer(RuntimeHttpFlow rtHttpFlow, RuntimePort rtPort) {
        TcpFlow mHttpFlowTemplate = rtHttpFlow.getModelHttpFlowTemplate();
        if (rtPort.hasRuntimeHttpServer(mHttpFlowTemplate)) {
            return rtPort.findRuntimeHttpServer(mHttpFlowTemplate);
        }
        return this.createHttpServer(rtHttpFlow, rtPort);
    }

    private RuntimeHttpServer createHttpServer(RuntimeHttpFlow rtHttpFlow, RuntimePort rtPort) {
        TcpFlowReader mHttpFlowTemplateReader = rtHttpFlow.getModelHttpFlowTemplateReader();
        Integer portNumber = -1;
        HTTPServer apiHttpServer = rtPort.getApiPort().ProtocolHttpServerAdd();
        try {
            if (!mHttpFlowTemplateReader.hasAutomaticServerPort()) {
                portNumber = mHttpFlowTemplateReader.getServerPortNumber();
                if (portNumber == null) {
                    throw new IllegalStateException("HTTP Server port number should be valid if not using automatic client port");
                }
                apiHttpServer.PortSet(portNumber.intValue());
            }
            try {
                apiHttpServer.TcpPragueEnable(rtHttpFlow.isTcpPragueEnabled());
            }
            catch (TechnicalError | UnsupportedFeature ex) {
                LOGGER.log(Level.INFO, "Server does not support TcpPrague", ex);
            }
            apiHttpServer.TcpCongestionAvoidanceAlgorithmSet(rtHttpFlow.getRuntimeTcpCongestionAvoidanceAlgorithm().getApiTcpCongestionAvoidanceAlgorithm());
            apiHttpServer.SlowStartThresholdSet(mHttpFlowTemplateReader.getSlowStartThreshold());
            apiHttpServer.ReceiveWindowInitialSizeSet(mHttpFlowTemplateReader.getInitialReceiveWindowSizeNumber().intValue());
            boolean useWindowSaling = mHttpFlowTemplateReader.usesReceiveWindowScaling();
            apiHttpServer.ReceiveWindowScalingEnable(useWindowSaling);
            if (useWindowSaling) {
                apiHttpServer.ReceiveWindowScalingValueSet(mHttpFlowTemplateReader.getRcvWindowScale());
            }
            apiHttpServer.Start();
            RuntimeHttpServer rtHttpServer = rtPort.addRuntimeHttpServer(apiHttpServer, (TcpFlow)mHttpFlowTemplateReader.getObject());
            return rtHttpServer;
        }
        catch (PortNumberAlreadyUsed portNumberAlreadyUsed) {
            throw new ProtocolPortAlreadyInUse("TCP port number " + portNumber + " cannot be used by more than one application per ByteBlower port.\nThis happens when you are using multiple TCP templates" + " with the same TCP Server port on the same ByteBlower port");
        }
    }

    private RuntimeHttpClient createHttpClient(RuntimeHttpFlow rtHttpFlow, RuntimePort rtPort, RuntimeHttpServer rtHttpServer, HTTPRequestMethod request) {
        PortMapping maps;
        int serverPort;
        FlowMeasurementReader mFlowInstanceReader = rtHttpFlow.getModelFlowInstanceReader();
        TcpFlowReader mHttpFlowTemplateReader = rtHttpFlow.getModelHttpFlowTemplateReader();
        HTTPClient apiHttpClient = rtPort.getApiPort().ProtocolHttpClientAdd();
        if (!mHttpFlowTemplateReader.hasAutomaticClientPort()) {
            Integer portNumber = mHttpFlowTemplateReader.getClientPortNumber();
            if (portNumber == null) {
                throw new IllegalStateException("HTTP Client port number should be valid if not using automatic client port");
            }
            try {
                apiHttpClient.LocalPortSet(portNumber.intValue());
            }
            catch (Exception exception) {
                throw new ProtocolPortAlreadyInUse("TCP port number " + portNumber + " cannot be used by more than one application per ByteBlower port");
            }
        }
        try {
            apiHttpClient.TcpPragueEnable(rtHttpFlow.isTcpPragueEnabled());
        }
        catch (TechnicalError | UnsupportedFeature ex) {
            LOGGER.log(Level.INFO, "Server does not support TcpPrague", ex);
        }
        apiHttpClient.TcpCongestionAvoidanceAlgorithmSet(rtHttpFlow.getRuntimeTcpCongestionAvoidanceAlgorithm().getApiTcpCongestionAvoidanceAlgorithm());
        apiHttpClient.SlowStartThresholdSet(mHttpFlowTemplateReader.getSlowStartThreshold());
        apiHttpClient.ReceiveWindowInitialSizeSet(mHttpFlowTemplateReader.getInitialReceiveWindowSizeNumber().intValue());
        boolean useWindowSaling = mHttpFlowTemplateReader.usesReceiveWindowScaling();
        apiHttpClient.ReceiveWindowScalingEnable(useWindowSaling);
        if (useWindowSaling) {
            apiHttpClient.ReceiveWindowScalingValueSet(mHttpFlowTemplateReader.getRcvWindowScale());
        }
        apiHttpClient.RequestStartTypeSet(HTTPClient.RequestStartType.Scheduled);
        Long startTime = mFlowInstanceReader.getStartTimeInNanoseconds();
        if (startTime == null) {
            throw new IllegalStateException("Each flow instance should have valid start time");
        }
        apiHttpClient.RequestInitialTimeToWaitSet(startTime.longValue());
        if (mHttpFlowTemplateReader.isTimeBased()) {
            Long durationInNanoseconds = mFlowInstanceReader.getDurationInNanoseconds();
            if (durationInNanoseconds == null) {
                throw new IllegalStateException("Time-based HTTP flow should have valid duration");
            }
            if (durationInNanoseconds == Long.MAX_VALUE) {
                durationInNanoseconds = 0x3FFFFFFFFFFFFFFFL;
            }
            apiHttpClient.RequestDurationSet(durationInNanoseconds.longValue());
        } else {
            float payloadSize = mHttpFlowTemplateReader.getPayloadSizeInBytes();
            if (payloadSize < 1.0f) {
                throw new IllegalStateException("Size-based HTTP flow should have valid payload size");
            }
            apiHttpClient.RequestSizeSet((long)payloadSize / (long)rtHttpFlow.getDivisor());
        }
        if (mHttpFlowTemplateReader.isRateLimited()) {
            long rateLimitBytesps = mHttpFlowTemplateReader.getRateLimitInBytesps();
            apiHttpClient.RequestRateLimitSet(rateLimitBytesps / (long)rtHttpFlow.getDivisor());
        }
        apiHttpClient.HttpMethodSet(request);
        int remotePort = serverPort = rtHttpServer.getApiPortNumber();
        String httpServerIpAddress = rtHttpServer.getIPAddress();
        if (rtHttpServer.getRuntimePort().isNatted() && (maps = this.findPortMapping(rtHttpServer)) != null) {
            LinkPath testPath = LinkPath.fromHTTP(rtHttpServer.getRuntimePort(), rtPort, rtHttpServer.getApiPortNumber(), apiHttpClient.LocalPortGet());
            ResolveResult resolved = new ResolveResult();
            NatDiscovery.createHttp(this.getContext(), resolved, rtHttpFlow, testPath, NatDiscovery.EndPointType.SOURCE).invoke();
            httpServerIpAddress = resolved.getPublicIp();
            remotePort = maps.getPublicPort();
        }
        apiHttpClient.RemoteAddressSet(httpServerIpAddress);
        apiHttpClient.RemotePortSet(remotePort);
        int tos = rtHttpFlow.getTos();
        try {
            apiHttpClient.TypeOfServiceSet(tos);
        }
        catch (TechnicalError | UnsupportedFeature ex) {
            LOGGER.log(Level.INFO, "Server does not support TOS", ex);
        }
        RuntimeHttpClient rtHttpClient = rtPort.addRuntimeHttpClient(apiHttpClient, rtHttpFlow);
        return rtHttpClient;
    }

    private PortMapping findPortMapping(RuntimeHttpServer rtHttpServer) {
        PortMapping NOT_FOUND = null;
        RuntimePort rtPort = rtHttpServer.getRuntimePort();
        PortForwarding f = rtPort.getModelPortReader().getPortForwarding();
        int remotePort = rtHttpServer.getApiPortNumber();
        if (f == null) {
            return NOT_FOUND;
        }
        for (PortMapping aMapping : f.getPortMappings()) {
            PortForwardingProtocol as = aMapping.getProtocol();
            if (remotePort != aMapping.getPrivatePort() || !as.equals((Object)PortForwardingProtocol.TCP)) continue;
            return aMapping;
        }
        return NOT_FOUND;
    }

    public static interface Listener {
    }

    private final class ResolveResult
    implements NatDiscovery.Listener {
        private String publicIp = null;

        private ResolveResult() {
        }

        public String getPublicIp() {
            if (this.publicIp == null) {
                throw new RuntimeInitializationError("Could not resolve HTTPServer");
            }
            return this.publicIp;
        }

        @Override
        public void onNatDiscovered(RuntimePort rtResolverPort, RuntimePort rtTargetPort, String publicIpv4, NatDiscovery.NatDiscoveryParameters natDiscovery) {
            this.publicIp = publicIpv4;
        }

        @Override
        public void onNatPortDiscovered(RuntimePort rtResolverPort, RuntimePort rtTargetPort, String publicIpv4, NatDiscovery.L4Protocol l4Protocol, Integer privateL4Port, Integer publicL4Port, NatDiscovery.NatDiscoveryParameters natDiscovery) {
            this.publicIp = publicIpv4;
        }

        @Override
        public void onNatDiscoveryFailed(RuntimePort resolver, RuntimePort target, String errorMessage) {
            throw new UserFriendlyInitializationError((AbstractAction)ConfigureFlowApplicationsHttp.this, new RuntimeInitializationError("Could not resolve HTTPServer"));
        }

        @Override
        public void onNatPortDiscoveryFailed(RuntimePort resolver, RuntimePort target, NatDiscovery.L4Protocol l4Protocol, Integer privateL4Port, String errorMessage) {
            throw new UserFriendlyInitializationError((AbstractAction)ConfigureFlowApplicationsHttp.this, new RuntimeInitializationError("Could not resolve HTTPServer"));
        }
    }
}

