/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.run.actions.ResolveMacAddress;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeHttpFlow;
import com.excentis.products.byteblower.run.objects.RuntimePort;

public final class ConfigureFlowTrafficHttp
extends ConcreteAction<Listener> {
    private final RuntimeHttpFlow rtHttpFlow;

    static AbstractAction create(Context context, RuntimeHttpFlow rtHttpFlow) {
        return context.decorate(new ConfigureFlowTrafficHttp(context, rtHttpFlow));
    }

    private ConfigureFlowTrafficHttp(Context context, RuntimeHttpFlow rtHttpFlow) {
        super(context, Listener.class);
        this.rtHttpFlow = rtHttpFlow;
    }

    @Override
    public String getDescription() {
        return "Configure traffic for flow '" + this.rtHttpFlow.name() + "' (HTTP)";
    }

    @Override
    public void invokeImpl() {
        if (this.rtHttpFlow.isMobileBased()) {
            ((Listener)this.getListener()).onHttpFlowTrafficConfigured(this.rtHttpFlow);
            return;
        }
        RuntimePort rtHttpClientPort = this.rtHttpFlow.getRuntimeHttpClient().getRuntimePort();
        String httpServerIpAddress = this.rtHttpFlow.getRuntimeHttpServer().getIPAddress();
        ResolveMacAddress.create(this.getContext(), rtHttpClientPort, httpServerIpAddress).invoke();
        ((Listener)this.getListener()).onHttpFlowTrafficConfigured(this.rtHttpFlow);
    }

    static interface Listener {
        public void onHttpFlowTrafficConfigured(RuntimeHttpFlow var1);
    }
}

