/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.run.actions.ConfigureFlow;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.exceptions.RuntimeInitializationError;
import com.excentis.products.byteblower.run.exceptions.UserFriendlyInitializationError;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimeGroupHttpFlow;
import com.excentis.products.byteblower.run.objects.RuntimeHttpFlow;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ConfigureFlows
extends ConcreteAction<Listener> {
    private final RuntimeScenario rtScenario;
    private final boolean ignoreInitializationErrors;
    private final Map<RuntimeFlow, UserFriendlyInitializationError> flowExceptions;

    static AbstractAction create(Context context, RuntimeScenario rtScenario) {
        return context.decorate(new ConfigureFlows(context, rtScenario));
    }

    private ConfigureFlows(Context context, RuntimeScenario rtScenario) {
        super(context, Listener.class);
        this.rtScenario = rtScenario;
        this.ignoreInitializationErrors = rtScenario.getRuntimeScenarioRunner().getRuntimePreferences().isIgnoreInitializationError();
        this.flowExceptions = new HashMap<RuntimeFlow, UserFriendlyInitializationError>();
    }

    @Override
    public String getDescription() {
        return "Configure flows";
    }

    @Override
    public void invokeImpl() {
        List<RuntimeFlow> rtFlows = this.rtScenario.getRuntimeFlows();
        ArrayList<RuntimeFlow> sortedRtFlows = new ArrayList<RuntimeFlow>(rtFlows);
        Collections.sort(sortedRtFlows, new RuntimeFlowConfigurationSorter());
        RuntimeFbFlow.reInitialize();
        for (RuntimeFlow rtFlow : sortedRtFlows) {
            this.processFlow(rtFlow);
        }
        if (this.rtScenario.getRuntimeFlowsConfigured().size() == 0) {
            String errorMsg = "All flows failed to initialize\n";
            for (Map.Entry<RuntimeFlow, UserFriendlyInitializationError> exceptions : this.flowExceptions.entrySet()) {
                RuntimeFlow flow = exceptions.getKey();
                UserFriendlyInitializationError excep = exceptions.getValue();
                errorMsg = String.valueOf(errorMsg) + flow.name() + ": " + excep.getDetail() + "\n";
            }
            throw new RuntimeInitializationError(errorMsg);
        }
        ((Listener)this.getListener()).onFlowsConfigured(this.rtScenario);
    }

    private boolean processFlow(RuntimeFlow rtFlow) {
        switch (rtFlow.getState()) {
            case CREATED: {
                try {
                    ConfigureFlow.create(this.getContext(), rtFlow).invoke();
                }
                catch (UserFriendlyInitializationError ufie) {
                    if (this.ignoreInitializationErrors) {
                        this.flowExceptions.put(rtFlow, ufie);
                        return false;
                    }
                    throw ufie;
                }
                return true;
            }
            case CONFIGURED: 
            case FAILED: {
                throw new IllegalStateException("Runtime flow should only be processed once!");
            }
        }
        throw new IllegalStateException("Unknown rtPort state " + (Object)((Object)rtFlow.getState()) + " occured.");
    }

    public static interface Listener {
        public void onFlowsConfigured(RuntimeScenario var1);
    }

    private static class RuntimeFlowConfigurationSorter
    implements Comparator<RuntimeFlow> {
        public static final int TYPE_VALUE_HTTP = 400;
        public static final int TYPE_VALUE_FB = 1000;
        public static final int TYPE_VALUE_UNKNOWN = 10000;

        static {
            $SWITCH_TABLE$com$excentis$products$byteblower$run$objects$RuntimeFlow$Type = RuntimeFlowConfigurationSorter.$SWITCH_TABLE$com$excentis$products$byteblower$run$objects$RuntimeFlow$Type();
        }

        private RuntimeFlowConfigurationSorter() {
        }

        @Override
        public int compare(RuntimeFlow rtFlow1, RuntimeFlow rtFlow2) {
            if (rtFlow1 instanceof RuntimeGroupHttpFlow || rtFlow2 instanceof RuntimeGroupHttpFlow) {
                return 0;
            }
            switch (rtFlow1.getType()) {
                case HTTP: {
                    switch (rtFlow2.getType()) {
                        case HTTP: {
                            return this.compareHttpFlows((RuntimeHttpFlow)rtFlow1, (RuntimeHttpFlow)rtFlow2);
                        }
                        case FB: {
                            return -600;
                        }
                    }
                    return -9600;
                }
                case FB: {
                    switch (rtFlow2.getType()) {
                        case HTTP: {
                            return 600;
                        }
                        case FB: {
                            return this.compareFbFlows(rtFlow1, rtFlow2);
                        }
                    }
                    return -9000;
                }
            }
            return 0;
        }

        private int compareHttpFlows(RuntimeHttpFlow rtFlow1, RuntimeHttpFlow rtFlow2) {
            int serverCompare = this.httpServerCompare(rtFlow1, rtFlow2);
            if (serverCompare != 0) {
                return serverCompare;
            }
            return this.httpClientCompare(rtFlow1, rtFlow2);
        }

        private int httpServerCompare(RuntimeHttpFlow rtFlow1, RuntimeHttpFlow rtFlow2) {
            if (rtFlow1.usesAutomaticServer()) {
                if (rtFlow2.usesAutomaticServer()) {
                    return 0;
                }
                return 1;
            }
            if (rtFlow2.usesAutomaticServer()) {
                return -1;
            }
            return 0;
        }

        private int httpClientCompare(RuntimeHttpFlow rtFlow1, RuntimeHttpFlow rtFlow2) {
            if (rtFlow1.usesAutomaticClient()) {
                if (rtFlow2.usesAutomaticClient()) {
                    return 0;
                }
                return 1;
            }
            if (rtFlow2.usesAutomaticClient()) {
                return -1;
            }
            return 0;
        }

        private int compareFbFlows(RuntimeFlow rtFlow1, RuntimeFlow rtFlow2) {
            return 0;
        }
    }
}

