/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.ByteBlowerPort;
import com.excentis.products.byteblower.communication.api.EthernetConfiguration;
import com.excentis.products.byteblower.communication.api.Layer2Configuration;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeLayer2Configuration;
import com.excentis.products.byteblower.run.objects.RuntimePort;

public final class ConfigureLayer2
extends ConcreteAction<Listener> {
    private final RuntimePort rtPort;
    private final ByteBlowerGuiPortReader mPortReader;

    static AbstractAction create(Context context, RuntimePort rtPort) {
        return context.decorate(new ConfigureLayer2(context, rtPort));
    }

    private ConfigureLayer2(Context context, RuntimePort rtPort) {
        super(context, Listener.class);
        this.rtPort = rtPort;
        this.mPortReader = rtPort.getModelPortReader();
    }

    @Override
    public String getDescription() {
        return "Configure layer 2 of '" + this.rtPort.getName() + "'";
    }

    @Override
    public void invokeImpl() {
        if (this.rtPort.getState() == RuntimePort.State.CREATED) {
            ByteBlowerPort apiPort = this.rtPort.getApiPort();
            EthernetConfiguration apiEthernetConfig = apiPort.Layer2EthIISet();
            apiEthernetConfig.MacSet(this.mPortReader.getMacAddressString());
            RuntimeLayer2Configuration rtL2Config = this.rtPort.configureRuntimeLayer2Configuration((Layer2Configuration)apiEthernetConfig);
            ((Listener)this.getListener()).onLayer2Configured(rtL2Config);
        }
    }

    public static interface Listener {
        public void onLayer2Configured(RuntimeLayer2Configuration var1);
    }
}

