/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.HTTPClientMobile;
import com.excentis.products.byteblower.communication.api.HTTPRequestMethod;
import com.excentis.products.byteblower.model.reader.FlowMeasurementReader;
import com.excentis.products.byteblower.model.reader.TcpFlowReader;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeHttpFlow;
import com.excentis.products.byteblower.run.objects.RuntimeHttpServer;
import com.excentis.products.byteblower.run.objects.RuntimeMobileHttpClient;

public final class ConfigureMobileHTTP
extends ConcreteAction<Listener> {
    private static long NO_RATE_LIMIT = Long.MIN_VALUE;
    private final HTTPRequestMethod apiMethod;
    private final String destAddress;
    private final int remotePort;
    private final RuntimeMobileHttpClient runtimeMobile;
    private final long ratelimit;
    private final long requestDuration;
    private final long startTime;
    private final int tosConfig;
    private final boolean shouldRestart;
    private final boolean shouldL4S;
    private final boolean hasLocalPort;
    private final int localPort;

    static AbstractAction create(Context context, RuntimeHttpFlow rtHttpFlow, RuntimeMobileHttpClient client, RuntimeHttpServer server, HTTPRequestMethod apiMethod) {
        return context.decorate(new ConfigureMobileHTTP(context, rtHttpFlow, client, server, apiMethod));
    }

    private ConfigureMobileHTTP(Context context, RuntimeHttpFlow rtHttpFlow, RuntimeMobileHttpClient client, RuntimeHttpServer server, HTTPRequestMethod apiMethod) {
        super(context, Listener.class);
        this.apiMethod = apiMethod;
        this.destAddress = server.getIPAddress();
        this.remotePort = server.getApiPortNumber();
        FlowMeasurementReader reader = rtHttpFlow.getModelFlowInstanceReader();
        this.requestDuration = reader.getDurationInNanoseconds();
        this.startTime = reader.getStartTimeInNanoseconds();
        this.shouldRestart = rtHttpFlow.shouldRestart();
        this.shouldL4S = rtHttpFlow.isTcpPragueEnabled();
        this.runtimeMobile = client;
        TcpFlowReader modelHttp = rtHttpFlow.getModelHttpFlowTemplateReader();
        this.hasLocalPort = !modelHttp.hasAutomaticClientPort();
        this.localPort = this.hasLocalPort ? modelHttp.getClientPortNumber() : Integer.MIN_VALUE;
        this.ratelimit = modelHttp.isRateLimited() ? modelHttp.getRateLimitInBytesps() : NO_RATE_LIMIT;
        this.tosConfig = rtHttpFlow.getTos();
    }

    @Override
    public String getDescription() {
        return "Configure Mobile devices";
    }

    @Override
    public void invokeImpl() {
        HTTPClientMobile client = this.runtimeMobile.getAPIClient();
        client.HttpMethodSet(this.apiMethod);
        client.RequestDurationSet(this.requestDuration);
        client.RequestInitialTimeToWaitSet(this.startTime);
        client.RemoteAddressSet(this.destAddress);
        client.RemotePortSet(this.remotePort);
        client.TypeOfServiceSet(this.tosConfig);
        if (this.runtimeMobile.supportsRestart()) {
            client.RestartEnable(this.shouldRestart);
        }
        if (this.hasLocalPort) {
            client.LocalPortSet(this.localPort);
        }
        if (this.ratelimit > 0L) {
            client.RequestRateLimitSet(this.ratelimit);
        }
        if (this.runtimeMobile.supportsTcpPrague()) {
            client.TcpPragueEnable(this.shouldL4S);
        }
    }

    public RuntimeMobileHttpClient getRuntimeHttp() {
        return this.runtimeMobile;
    }

    public static interface Listener {
        public void onMobileTxConfigured();
    }
}

