/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.FrameMobile;
import com.excentis.products.byteblower.communication.api.StreamMobile;
import com.excentis.products.byteblower.frame.Ipv4Packet;
import com.excentis.products.byteblower.frame.Ipv6Packet;
import com.excentis.products.byteblower.frame.ProtocolField;
import com.excentis.products.byteblower.frame.UDPPacket;
import com.excentis.products.byteblower.model.reader.FlowMeasurementReader;
import com.excentis.products.byteblower.model.reader.FrameBlastingFlowReader;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.filters.core.BPFFilter;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFlowDestination;
import com.excentis.products.byteblower.run.objects.RuntimeFrame;
import com.excentis.products.byteblower.run.objects.RuntimeFrameTx;
import com.excentis.products.byteblower.run.objects.RuntimeMobileDevice;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;

public final class ConfigureMobileTx
extends ConcreteAction<Listener> {
    private final String destIpAddress;
    private final int dstPort;
    private final int srcPort;
    private final long initialTimeToWait;
    private final long interFrameGap;
    private final long numberOfFrames;
    private final List<byte[]> hexFrames = new ArrayList<byte[]>();
    private final RuntimeFbFlow rtFbFlow;
    private final int tosConfig;
    private final boolean hasLatency;

    static AbstractAction create(Context context, RuntimeFbFlow rtFbFlow) {
        return context.decorate(new ConfigureMobileTx(context, rtFbFlow));
    }

    private ConfigureMobileTx(Context context, RuntimeFbFlow rtFbFlow) {
        super(context, Listener.class);
        this.rtFbFlow = rtFbFlow;
        FlowMeasurementReader flowInstanceReader = rtFbFlow.getModelFlowInstanceReader();
        FrameBlastingFlowReader fbFlowTemplateReader = rtFbFlow.getModelFbFlowTemplateReader();
        RuntimeFlowDestination destination = rtFbFlow.getRuntimeFlowDestination();
        RuntimeMobileDevice source = (RuntimeMobileDevice)rtFbFlow.getSourceRuntimePort();
        this.initialTimeToWait = flowInstanceReader.getStartTimeInNanoseconds();
        this.interFrameGap = fbFlowTemplateReader.getFrameIntervalInNanoseconds();
        List<RuntimeFrameTx> frames = rtFbFlow.getRuntimeFramesTx();
        this.numberOfFrames = flowInstanceReader.getNumberOfFrames();
        this.hasLatency = rtFbFlow.hasLatencyMeasurement();
        int localDstPort = 0;
        int localSrcPort = 0;
        boolean autoDest = true;
        String frameAddress = new String();
        int localTOS = 0;
        for (RuntimeFrame runtimeFrame : frames) {
            byte[] data;
            ProtocolField payload;
            UDPPacket udp;
            Ipv6Packet packet;
            autoDest = runtimeFrame.getModelFbFrame().getL3AutoDestIp();
            if (source.isIpv6()) {
                packet = (Ipv6Packet)runtimeFrame.getLayer(BPFFilter.Proto.IPv6);
                frameAddress = packet.getDestinationAddress();
                localTOS = 0xFF & packet.getTrafficClass();
                udp = (UDPPacket)runtimeFrame.getLayer(BPFFilter.Proto.UDP);
                localDstPort = udp.getDestination();
                localSrcPort = udp.getSource();
                payload = udp.getPayload();
                data = new byte[payload.getSize() / 8];
                udp.getPayload().dump(data, 0);
                this.hexFrames.add(data);
                continue;
            }
            packet = (Ipv4Packet)runtimeFrame.getLayer(BPFFilter.Proto.IPv4);
            frameAddress = packet.getDestinationAddress();
            localTOS = 0xFF & packet.getTOS();
            udp = (UDPPacket)runtimeFrame.getLayer(BPFFilter.Proto.UDP);
            localDstPort = udp.getDestination();
            localSrcPort = udp.getSource();
            payload = udp.getPayload();
            data = new byte[payload.getSize() / 8];
            udp.getPayload().dump(data, 0);
            this.hexFrames.add(data);
        }
        this.tosConfig = localTOS;
        this.destIpAddress = autoDest ? destination.getIPAddress() : frameAddress;
        this.dstPort = localDstPort;
        this.srcPort = localSrcPort;
        rtFbFlow.setFrameTagTx(null);
    }

    @Override
    public String getDescription() {
        return "Configure Mobile devices";
    }

    @Override
    public void invokeImpl() {
        RuntimeMobileDevice source = (RuntimeMobileDevice)this.rtFbFlow.getSourceRuntimePort();
        StreamMobile stream = source.getMobilePort().TxStreamAdd();
        this.rtFbFlow.setApiStream(stream);
        stream.InitialTimeToWaitSet(this.initialTimeToWait);
        stream.InterFrameGapSet(this.interFrameGap);
        stream.NumberOfFramesSet(this.numberOfFrames);
        stream.DestinationAddressSet(this.destIpAddress);
        stream.DestinationPortSet(this.dstPort);
        stream.SourcePortSet(this.srcPort);
        stream.TypeOfServiceSet(this.tosConfig);
        for (byte[] data : this.hexFrames) {
            Formatter strData = new Formatter();
            byte[] byArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                byte d = byArray[n2];
                strData.format("%02x", d & 0xFF);
                ++n2;
            }
            FrameMobile apiFrame = stream.FrameAdd();
            apiFrame.PayloadSet(strData.toString());
            this.rtFbFlow.setFrameTagTx(apiFrame.FrameTagTimeGet());
            apiFrame.FrameTagTimeGet().Enable(this.hasLatency);
            strData.close();
        }
    }

    public static interface Listener {
        public void onMobileTxConfigured();
    }
}

