/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.reader.FlowMeasurementReader;
import com.excentis.products.byteblower.model.reader.ScenarioReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.exceptions.UserFriendlyInitializationError;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import java.util.ArrayList;
import java.util.List;

public final class ConfigurePorts
extends ConcreteAction<Listener> {
    private final RuntimeScenario rtScenario;
    private final boolean ignoreInitializationErrors;
    private final boolean configureObsoletePorts;

    static AbstractAction create(Context context, RuntimeScenario rtScenario) {
        return context.decorate(new ConfigurePorts(context, rtScenario));
    }

    private ConfigurePorts(Context context, RuntimeScenario rtScenario) {
        super(context, Listener.class);
        this.rtScenario = rtScenario;
        this.ignoreInitializationErrors = rtScenario.getRuntimeScenarioRunner().getRuntimePreferences().isIgnoreInitializationError();
        this.configureObsoletePorts = false;
    }

    @Override
    public String getDescription() {
        return "Configure ports";
    }

    @Override
    public void invokeImpl() {
        ScenarioReader scenarioReader = this.rtScenario.getModelScenarioReader();
        List flowInstances = scenarioReader.getSortedFlowMeasurements();
        ArrayList<FlowMeasurement> goodFlows = new ArrayList<FlowMeasurement>();
        for (FlowMeasurement flowInstance : flowInstances) {
            if (!this.processFlowInstance(flowInstance)) continue;
            goodFlows.add(flowInstance);
        }
        for (FlowMeasurement flowInstance : goodFlows) {
            this.processFlowInstance(flowInstance);
        }
        ((Listener)this.getListener()).onPortsConfigured(this.rtScenario);
    }

    private boolean processFlowInstance(FlowMeasurement flowInstance) {
        FlowMeasurementReader mFlowInstanceReader = ReaderFactory.create((FlowMeasurement)flowInstance);
        ByteBlowerGuiPort mSourcePort = mFlowInstanceReader.getSourcePort();
        boolean srcPortConfigured = this.processPort(this.rtScenario.findRuntimePort(mSourcePort));
        if (!srcPortConfigured && !this.configureObsoletePorts) {
            return false;
        }
        if (mFlowInstanceReader.hasDestinationPorts()) {
            boolean singleDstPortConfigured = false;
            for (ByteBlowerGuiPort mDestinationPort : mFlowInstanceReader.getDestinationPorts()) {
                boolean dstPortConfigured = this.processPort(this.rtScenario.findRuntimePort(mDestinationPort));
                if (!dstPortConfigured) continue;
                singleDstPortConfigured = true;
            }
            if (!singleDstPortConfigured && !this.configureObsoletePorts) {
                return false;
            }
        }
        if (mFlowInstanceReader.hasEavesdropperPorts()) {
            for (ByteBlowerGuiPort mDestinationPort : mFlowInstanceReader.getEavesdropperPorts()) {
                this.processPort(this.rtScenario.findRuntimePort(mDestinationPort));
            }
        }
        return true;
    }

    private boolean processPort(RuntimePort rtPort) {
        AbstractAction action = rtPort.createConfigureAction(this);
        switch (rtPort.getState()) {
            case CREATED: {
                try {
                    action.invoke();
                }
                catch (UserFriendlyInitializationError ufie) {
                    if (this.ignoreInitializationErrors) {
                        return false;
                    }
                    throw ufie;
                }
                return true;
            }
            case CONFIGURED_AND_WAITING_FOR_ASYNC: {
                try {
                    action.invoke();
                }
                catch (UserFriendlyInitializationError ufie) {
                    if (this.ignoreInitializationErrors) {
                        return false;
                    }
                    throw ufie;
                }
                return true;
            }
            case CONFIGURED: {
                return true;
            }
            case FAILED: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown rtPort state " + (Object)((Object)rtPort.getState()) + " occured.");
    }

    public static interface Listener {
        public void onPortsConfigured(RuntimeScenario var1);
    }
}

