/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.run.actions.NatDiscovery;
import com.excentis.products.byteblower.run.actions.ResolveMacAddress;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.exceptions.RuntimeInitializationError;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFrame;
import com.excentis.products.byteblower.run.objects.RuntimeFrameTx;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import java.util.ArrayList;

public final class CreateFrame
extends ConcreteAction<Listener> {
    private final RuntimeFlow rtFlow;
    private final FrameReader mFbFrameReader;

    public static AbstractAction create(Context context, RuntimeFlow rtFlow, FrameReader mFbFrameReader) {
        return context.decorate(new CreateFrame(context, rtFlow, mFbFrameReader));
    }

    private CreateFrame(Context context, RuntimeFlow rtFlow, FrameReader mFbFrameReader) {
        super(context, Listener.class);
        this.rtFlow = rtFlow;
        this.mFbFrameReader = mFbFrameReader;
    }

    @Override
    public String getDescription() {
        return "Create frame '" + this.mFbFrameReader.getName() + "' for flow '" + this.rtFlow.name() + "'";
    }

    @Override
    public void invokeImpl() {
        RuntimeFrameTx rtFrameTx = new RuntimeFrameTx(this.rtFlow, (Frame)this.mFbFrameReader.getObject());
        boolean needsNatDiscovery = this.rtFlow.getRuntimeFlowDestination().isNatted() && NatDiscovery.isNATDiscoverable(rtFrameTx);
        ArrayList<AbstractAction> natDiscoveryActions = new ArrayList<AbstractAction>();
        if (needsNatDiscovery) {
            NatDiscovery.EndPointType direction = NatDiscovery.EndPointType.DESTINATION;
            AbstractAction natDiscoveryAction = NatDiscovery.create(this.getContext(), rtFrameTx, direction);
            natDiscoveryActions.add(natDiscoveryAction);
        }
        if (this.rtFlow.getRuntimeFlowSource().isNatted() && NatDiscovery.isNATDiscoverable(rtFrameTx) && rtFrameTx.isUnicast()) {
            boolean hasRxPorts;
            boolean bl = hasRxPorts = this.rtFlow.getDestinationAndEavesdropperRuntimePortsConfigured().size() > 0;
            if (hasRxPorts) {
                NatDiscovery.EndPointType direction = NatDiscovery.EndPointType.SOURCE;
                AbstractAction natDiscoveryAction = NatDiscovery.create(this.getContext(), rtFrameTx, direction);
                natDiscoveryActions.add(natDiscoveryAction);
            }
        }
        NatDiscoverer natCallBack = new NatDiscoverer(rtFrameTx);
        this.getContext().listen(NatDiscovery.Listener.class, natCallBack);
        for (AbstractAction aDirection : natDiscoveryActions) {
            aDirection.prepare();
            aDirection.invoke();
            if (natCallBack.hadSuccess) break;
        }
        needsNatDiscovery = natCallBack.hasTranslatedAddress;
        if (!natCallBack.hadSuccess && !natDiscoveryActions.isEmpty()) {
            throw new RuntimeInitializationError("Source NAT discovery temporary flow was not received");
        }
        this.getContext().unlisten(NatDiscovery.Listener.class, natCallBack);
        if (rtFrameTx.getModelFbFrame().getL2AutoDestMac().booleanValue()) {
            String flowDestinationIp;
            if (needsNatDiscovery) {
                if (rtFrameTx.getPublicDestinationIpAddress() == null) {
                    throw new IllegalStateException("Public destination address not set, even though NAT discovery enabled");
                }
                flowDestinationIp = rtFrameTx.getPublicDestinationIpAddress();
            } else {
                flowDestinationIp = this.rtFlow.getRuntimeFlowDestination().getIPAddress();
            }
            this.resolveLayer2Address(flowDestinationIp, rtFrameTx);
        }
        rtFrameTx.applyDynamicConfiguration();
        this.rtFlow.getSourceRuntimePort().addTxFrame(rtFrameTx);
    }

    private void resolveLayer2Address(String flowDestinationIp, RuntimeFrameTx rtFrameTx) {
        RuntimePort resolvePort = this.rtFlow.getSourceRuntimePort();
        MacCallBack resolver = new MacCallBack(resolvePort, flowDestinationIp, rtFrameTx);
        resolver.resolveMac(this.getContext());
    }

    public static interface Listener {
        public void onFrameCreated(RuntimeFrame var1);

        public void onFrameCreationFailed(RuntimeFrame var1, String var2);
    }

    private static final class MacCallBack
    implements ResolveMacAddress.Listener {
        private final RuntimePort resolvePort;
        private final String flowDestinationIp;
        private final RuntimeFrameTx rtFrameTx;

        private MacCallBack(RuntimePort resolvePort, String flowDestinationIp, RuntimeFrameTx frame) {
            this.resolvePort = resolvePort;
            this.flowDestinationIp = flowDestinationIp;
            this.rtFrameTx = frame;
        }

        public void resolveMac(Context context) {
            context.listen(ResolveMacAddress.Listener.class, this);
            ResolveMacAddress.create(context, this.resolvePort, this.flowDestinationIp).invoke();
            context.unlisten(ResolveMacAddress.Listener.class, this);
        }

        @Override
        public void onMacAddressResolved(RuntimePort resolver, String ipAddressString, String macAddress) {
            if (resolver == this.resolvePort && this.flowDestinationIp.equals(ipAddressString)) {
                this.rtFrameTx.setResolvedMacAddress(macAddress);
            }
        }

        @Override
        public void onMacAddressResolveFailed(RuntimePort resolver, String ipAddressString) {
        }
    }

    private static final class NatDiscoverer
    implements NatDiscovery.Listener {
        private final RuntimeFrameTx rtFrameTx;
        boolean hadSuccess = false;
        boolean hasTranslatedAddress = false;

        public NatDiscoverer(RuntimeFrameTx rtFrameTx) {
            this.rtFrameTx = rtFrameTx;
        }

        @Override
        public void onNatDiscovered(RuntimePort rtResolverPort, RuntimePort rtTargetPort, String publicIpv4, NatDiscovery.NatDiscoveryParameters natDiscovery) {
            this.hadSuccess = true;
            if (this.rtFrameTx.getRuntimeFlow().getSourceRuntimePort() == rtTargetPort) {
                this.rtFrameTx.setPublicSourceIpAddress(publicIpv4);
            } else {
                this.rtFrameTx.setPublicDestinationIpAddress(publicIpv4);
                this.hasTranslatedAddress = true;
            }
        }

        @Override
        public void onNatPortDiscovered(RuntimePort rtResolverPort, RuntimePort rtTargetPort, String publicIpv4, NatDiscovery.L4Protocol l4Protocol, Integer privateL4Port, Integer publicL4Port, NatDiscovery.NatDiscoveryParameters natDiscovery) {
            this.hadSuccess = true;
            if (this.rtFrameTx.getRuntimeFlow().getSourceRuntimePort() == rtTargetPort) {
                this.rtFrameTx.setPublicSourceIpAddress(publicIpv4);
                this.rtFrameTx.setPublicSourceL4Port(publicL4Port);
            } else {
                this.rtFrameTx.setPublicDestinationIpAddress(publicIpv4);
                this.rtFrameTx.setPublicDestinationL4Port(publicL4Port);
                this.hasTranslatedAddress = true;
            }
        }

        @Override
        public void onNatDiscoveryFailed(RuntimePort resolver, RuntimePort target, String errorMessage) {
            this.hadSuccess = false;
        }

        @Override
        public void onNatPortDiscoveryFailed(RuntimePort resolver, RuntimePort target, NatDiscovery.L4Protocol l4Protocol, Integer privateL4Port, String errorMessage) {
            this.hadSuccess = false;
        }
    }
}

