/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.ByteBlowerServerIncompatible;
import com.excentis.products.byteblower.communication.api.MeetingPointUnreachable;
import com.excentis.products.byteblower.run.actions.CreateServer;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeByteBlower;
import com.excentis.products.byteblower.run.objects.RuntimeMeetingPoint;

public final class CreateMeetingPoint
extends ConcreteAction<Listener> {
    private final RuntimeByteBlower rtByteBlower;
    private final String serverUrl;

    static AbstractAction create(Context context, RuntimeByteBlower runtimeByteBlower, String serverUrl) {
        return context.decorate(new CreateMeetingPoint(context, runtimeByteBlower, serverUrl));
    }

    private CreateMeetingPoint(Context context, RuntimeByteBlower rtByteBlower, String serverUrl) {
        super(context, Listener.class);
        this.rtByteBlower = rtByteBlower;
        this.serverUrl = serverUrl;
    }

    @Override
    public String getDescription() {
        return "Create server " + this.serverUrl;
    }

    @Override
    public void invokeImpl() {
        try {
            RuntimeMeetingPoint rtServer = this.rtByteBlower.addMeetingPoint(this.serverUrl);
            ((Listener)this.getListener()).onMeetingPointCreated(rtServer);
        }
        catch (ByteBlowerServerIncompatible e) {
            ((Listener)this.getListener()).onServerCreationFailed(this.serverUrl, CreateServer.Listener.ErrorType.INCOMPATIBLE_VERSION, e.getMessage());
            throw e;
        }
        catch (MeetingPointUnreachable e) {
            ((Listener)this.getListener()).onServerCreationFailed(this.serverUrl, CreateServer.Listener.ErrorType.UNKNOWN_ERROR, e.getMessage());
            throw e;
        }
    }

    public static interface Listener {
        public void onMeetingPointCreated(RuntimeMeetingPoint var1);

        public void onServerCreationFailed(String var1, CreateServer.Listener.ErrorType var2, String var3);
    }
}

