/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.ByteBlowerPort;
import com.excentis.products.byteblower.communication.api.ByteBlowerServer;
import com.excentis.products.byteblower.communication.api.ConfigError;
import com.excentis.products.byteblower.communication.api.MeetingPoint;
import com.excentis.products.byteblower.communication.api.PhysicalInterface;
import com.excentis.products.byteblower.communication.api.PhysicalInterfaceList;
import com.excentis.products.byteblower.communication.api.PhysicalInterfaceType;
import com.excentis.products.byteblower.communication.api.WirelessEndpoint;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerGuiPortConfiguration;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeBBServer;
import com.excentis.products.byteblower.run.objects.RuntimeInterface;
import com.excentis.products.byteblower.run.objects.RuntimeMeetingPoint;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;

public final class CreatePort
extends ConcreteAction<Listener> {
    public static final int WORK = 1;
    private final RuntimeScenario rtScenario;
    private final ByteBlowerGuiPortReader mPortReader;
    private final PortStrategy strategy;

    static AbstractAction create(Context context, RuntimeScenario rtScenario, RuntimeBBServer rtServer, ByteBlowerGuiPort mPort) {
        return context.decorate(new CreatePort(context, rtScenario, rtServer, mPort));
    }

    static AbstractAction create(Context context, RuntimeScenario rtScenario, RuntimeMeetingPoint rtServer, ByteBlowerGuiPort mPort) {
        return context.decorate(new CreatePort(context, rtScenario, rtServer, mPort));
    }

    private CreatePort(Context context, RuntimeScenario rtScenario, RuntimeBBServer rtServer, ByteBlowerGuiPort mPort) {
        super(context, Listener.class);
        this.rtScenario = rtScenario;
        this.mPortReader = ReaderFactory.create((ByteBlowerGuiPort)mPort);
        this.strategy = new CreateBBPort(rtServer);
    }

    private CreatePort(Context context, RuntimeScenario rtScenario, RuntimeMeetingPoint rtServer, ByteBlowerGuiPort mPort) {
        super(context, Listener.class);
        this.rtScenario = rtScenario;
        this.mPortReader = ReaderFactory.create((ByteBlowerGuiPort)mPort);
        this.strategy = new CreateMeetingPointPort(rtServer);
    }

    @Override
    public String getDescription() {
        return "Create port '" + this.mPortReader.getName() + "'";
    }

    @Override
    public void invokeImpl() {
        try {
            RuntimePort port = this.strategy.create();
            ((Listener)this.getListener()).onPortCreated(port);
        }
        catch (ConfigError e) {
            ((Listener)this.getListener()).onPortCreationFailed(null, e.getMessage());
            throw e;
        }
    }

    private class CreateBBPort
    extends PortStrategy {
        private final RuntimeBBServer rtServer;

        public CreateBBPort(RuntimeBBServer rtServer) {
            this.rtServer = rtServer;
        }

        @Override
        RuntimePort create() {
            ByteBlowerServer apiServer = this.rtServer.getApiServer();
            String physicalInterfaceString = this.getInterfaceString();
            RuntimeInterface rtInterface = this.rtServer.getRuntimeInterface(physicalInterfaceString);
            if (rtInterface == null) {
                throw new ConfigError("Unknown interface: " + physicalInterfaceString);
            }
            ByteBlowerPort apiPort = apiServer.PortCreate(physicalInterfaceString);
            RuntimePort rtPort = CreatePort.this.rtScenario.registerRuntimePort(rtInterface, apiPort, (ByteBlowerGuiPort)CreatePort.this.mPortReader.getObject());
            return rtPort;
        }

        private String getInterfaceString() {
            ByteBlowerGuiPortConfiguration config = CreatePort.this.mPortReader.getByteBlowerGuiPortConfiguration();
            int interfaceId = Integer.valueOf(config.getPhysicalInterfaceId());
            return this.composeInterfaceString(this.rtServer, interfaceId, config.getPhysicalPortId());
        }

        private String composeInterfaceString(RuntimeBBServer server, int physicalInterfaceId, int portId) {
            PhysicalInterfaceList interfaces = server.getApiServer().PhysicalInterfacesGet();
            PhysicalInterface physicalInterface = interfaces.get(physicalInterfaceId);
            String result = physicalInterface.NameGet();
            if (physicalInterface.TypeGet().equals(PhysicalInterfaceType.Trunk)) {
                result = String.valueOf(result) + "-" + (portId + 1);
            }
            return result;
        }
    }

    private class CreateMeetingPointPort
    extends PortStrategy {
        private final RuntimeMeetingPoint rtMeetingPoint;

        public CreateMeetingPointPort(RuntimeMeetingPoint rtServer) {
            this.rtMeetingPoint = rtServer;
        }

        @Override
        RuntimePort create() throws ConfigError {
            MeetingPoint apiServer = this.rtMeetingPoint.getApiServer();
            String physicalInterfaceString = this.getInterfaceString();
            RuntimeInterface rtInterface = this.rtMeetingPoint.getRuntimeInterface(physicalInterfaceString);
            if (rtInterface == null) {
                throw new ConfigError("Unknown Wireless Endpoint");
            }
            WirelessEndpoint apiPort = apiServer.DeviceGet(physicalInterfaceString);
            RuntimePort rtPort = CreatePort.this.rtScenario.registerRuntimePort(rtInterface, apiPort, (ByteBlowerGuiPort)CreatePort.this.mPortReader.getObject());
            return rtPort;
        }

        private String getInterfaceString() {
            ByteBlowerGuiPortConfiguration config = CreatePort.this.mPortReader.getByteBlowerGuiPortConfiguration();
            return config.getPhysicalInterfaceId();
        }
    }

    public static interface Listener {
        public void onPortCreated(RuntimePort var1);

        public void onPortCreationFailed(RuntimePort var1, String var2);
    }

    private static abstract class PortStrategy {
        private PortStrategy() {
        }

        abstract RuntimePort create() throws ConfigError;
    }
}

