/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.ConfigError;
import com.excentis.products.byteblower.communication.api.InitializationError;
import com.excentis.products.byteblower.run.actions.core.CancellationTriggered;
import com.excentis.products.byteblower.run.actions.core.Decorator;
import com.excentis.products.byteblower.run.exceptions.RuntimeDomainError;
import com.excentis.products.byteblower.run.exceptions.RuntimeInitializationError;
import com.excentis.products.byteblower.run.exceptions.UserFriendlyDomainError;
import com.excentis.products.byteblower.run.exceptions.UserFriendlyError;
import com.excentis.products.byteblower.run.exceptions.UserFriendlyInitializationError;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;

public class ExceptionCatcher
extends Decorator {
    @Override
    public void invokeImpl() {
        try {
            this.getDecoratedAction().invoke();
        }
        catch (UserFriendlyError ex) {
            throw ex;
        }
        catch (CancellationTriggered ex) {
            throw ex;
        }
        catch (InitializationError apiInitializationError) {
            throw new UserFriendlyInitializationError(this.getConcreteAction(), apiInitializationError);
        }
        catch (ConfigError rtApiConfigError) {
            throw new UserFriendlyInitializationError(this.getConcreteAction(), rtApiConfigError);
        }
        catch (RuntimeInitializationError rtInitializationError) {
            throw new UserFriendlyInitializationError(this.getConcreteAction(), rtInitializationError);
        }
        catch (RuntimeDomainError rtDomainError) {
            throw new UserFriendlyDomainError(this.getConcreteAction(), rtDomainError);
        }
        catch (UndeclaredThrowableException e) {
            Throwable baseCause = e.getCause();
            if (baseCause instanceof InvocationTargetException) {
                InvocationTargetException wrappedException = (InvocationTargetException)baseCause;
                throw new UserFriendlyError(this.getConcreteAction(), wrappedException.getCause());
            }
            throw new UserFriendlyError(this.getConcreteAction(), (Throwable)e);
        }
        catch (RuntimeException e) {
            String message = e.getMessage();
            if (message != null && message.contains("C++ std::exception: ConnectionError")) {
                throw new UserFriendlyError(this.getConcreteAction(), (Throwable)new RuntimeException("Lost network connection to the ByteBlower server. Test aborted."));
            }
            throw new UserFriendlyError(this.getConcreteAction(), (Throwable)e);
        }
        catch (Exception t) {
            throw new UserFriendlyError(this.getConcreteAction(), (Throwable)t);
        }
    }

    @Override
    protected Decorator getDecoratorCopy() {
        return new ExceptionCatcher();
    }
}

