/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.Buffer;
import com.excentis.products.byteblower.communication.api.ByteBlowerPort;
import com.excentis.products.byteblower.communication.api.CaptureRawPacket;
import com.excentis.products.byteblower.communication.api.CaptureResultSnapshot;
import com.excentis.products.byteblower.communication.api.CapturedFrame;
import com.excentis.products.byteblower.communication.api.CapturedFrameList;
import com.excentis.products.byteblower.frame.EthernetPacket;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.run.actions.Wait;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.actions.natdiscovery.Direction;
import com.excentis.products.byteblower.run.actions.natdiscovery.Forward;
import com.excentis.products.byteblower.run.actions.natdiscovery.LinkPath;
import com.excentis.products.byteblower.run.actions.natdiscovery.LinkProbe;
import com.excentis.products.byteblower.run.actions.natdiscovery.NATCache;
import com.excentis.products.byteblower.run.actions.natdiscovery.Reverse;
import com.excentis.products.byteblower.run.exceptions.RuntimeInitializationError;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFrame;
import com.excentis.products.byteblower.run.objects.RuntimeHttpFlow;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimePortDestination;
import java.util.logging.Logger;

public final class NatDiscovery
extends ConcreteAction<Listener> {
    private static final Logger LOGGER = Logger.getGlobal();
    private static final long NAT_STREAM_INTERFRAMEGAP_NS = 100000000L;
    private static final int NAT_STREAM_WAITTIME_MS = 1000;
    private final EndPointType natType;
    private final RuntimePort rtNatPort;
    private final RuntimePort rtExternPort;
    private RuntimePort.NatStream apiNatStream;
    private CaptureRawPacket apiNatCapture;
    private final Direction dir;
    private final LinkPath natLink;
    private LinkPath other;
    private final FrameReader mFbFrameReader;
    private final String frameDescription;
    private boolean isPrepared = false;
    private LinkProbe probe;

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$run$actions$NatDiscovery$EndPointType = NatDiscovery.$SWITCH_TABLE$com$excentis$products$byteblower$run$actions$NatDiscovery$EndPointType();
    }

    static AbstractAction create(Context context, RuntimeFrame rtFrame, EndPointType natType) {
        NatDiscovery discovery = natType == EndPointType.SOURCE ? new NatDiscovery(context, rtFrame, natType, new Forward()) : new NatDiscovery(context, rtFrame, natType, new Reverse());
        return context.decorate(discovery);
    }

    static AbstractAction createHttp(Context context, Listener listener, RuntimeHttpFlow flow, LinkPath path, EndPointType natType) {
        NatDiscovery discovery = natType == EndPointType.SOURCE ? new NatDiscovery(context, path, flow, natType, new Reverse()) : new NatDiscovery(context, path, flow, natType, new Forward());
        return context.decorate(discovery);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NatDiscovery(Context context, RuntimeFrame rtFrame, EndPointType natType, Direction direction) {
        super(context, Listener.class);
        this.dir = direction;
        RuntimeFlow rtFlow = rtFrame.getRuntimeFlow();
        this.natType = natType;
        if (natType == EndPointType.DESTINATION) {
            if (!(rtFlow.getRuntimeFlowDestination() instanceof RuntimePortDestination)) {
                throw new IllegalStateException("Destination NAT discovery is only possible on port destinations");
            }
            this.rtNatPort = ((RuntimePortDestination)rtFlow.getRuntimeFlowDestination()).getRuntimePort();
            this.rtExternPort = rtFlow.getSourceRuntimePort();
        } else {
            if (natType != EndPointType.SOURCE) throw new IllegalStateException("Unsupported NAT discovery type " + (Object)((Object)natType));
            this.rtNatPort = rtFlow.getSourceRuntimePort();
            if (rtFlow.getDestinationAndEavesdropperRuntimePortsConfigured().size() <= 0) throw new IllegalStateException("Source NAT discovery is only possible if destination exists");
            this.rtExternPort = rtFlow.getRuntimeFlowDestination().getRuntimePorts().get(0);
        }
        if (this.rtExternPort.isMobile()) {
            throw new IllegalStateException("Wireless Endpoints can't discover NAT translations");
        }
        this.mFbFrameReader = ReaderFactory.create((Frame)rtFrame.getModelFbFrame());
        this.natLink = new LinkPath(this.rtNatPort, this.rtExternPort, this.mFbFrameReader, this.dir);
        this.frameDescription = rtFrame.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NatDiscovery(Context context, LinkPath path, RuntimeFlow rtFlow, EndPointType natType, Direction direction) {
        super(context, Listener.class);
        this.dir = direction;
        this.natType = natType;
        this.mFbFrameReader = null;
        this.frameDescription = "Http";
        if (natType == EndPointType.DESTINATION) {
            if (!(rtFlow.getRuntimeFlowDestination() instanceof RuntimePortDestination)) {
                throw new IllegalStateException("Destination NAT discovery is only possible on port destinations");
            }
            this.rtNatPort = ((RuntimePortDestination)rtFlow.getRuntimeFlowDestination()).getRuntimePort();
            this.rtExternPort = rtFlow.getSourceRuntimePort();
        } else {
            if (natType != EndPointType.SOURCE) throw new IllegalStateException("Unsupported NAT discovery type " + (Object)((Object)natType));
            this.rtNatPort = rtFlow.getSourceRuntimePort();
            if (rtFlow.getDestinationAndEavesdropperRuntimePortsConfigured().size() <= 0) throw new IllegalStateException("Source NAT discovery is only possible if destination exists");
            this.rtExternPort = rtFlow.getRuntimeFlowDestination().getRuntimePorts().get(0);
        }
        this.natLink = path;
    }

    public static boolean isNATDiscoverable(RuntimeFrame frame) {
        return frame.hasIPv4Header() || frame.hasIPv6Header();
    }

    @Override
    public String getDescription() {
        switch (this.natType) {
            case DESTINATION: {
                return "Source NAT discovery for frame '" + this.frameDescription + "'";
            }
            case SOURCE: {
                return "Destination NAT discovery for frame '" + this.frameDescription + "'";
            }
        }
        return "No configuration";
    }

    @Override
    public void prepare() {
        try {
            NATCache cache = this.rtNatPort.query(this.dir);
            if (!cache.isResolved(this.natLink)) {
                this.probe = cache.createProbe(this.natLink, this.rtNatPort, this.rtExternPort, this.mFbFrameReader);
                if (this.probe == null) {
                    throw new RuntimeInitializationError("Invalid base frame)");
                }
                String filter = cache.createFilter(this.natLink);
                this.createNatDiscoveryFlow(this.probe, filter);
                this.apiNatCapture.Start();
                this.apiNatStream.start(this.getContext());
            }
            this.isPrepared = true;
        }
        catch (RuntimeInitializationError e) {
            ((Listener)this.getListener()).onNatPortDiscoveryFailed(this.rtExternPort, this.rtNatPort, this.natLink.protocol(), this.natLink.getPort(), e.getMessage());
            throw e;
        }
    }

    @Override
    public void invokeImpl() {
        try {
            NATCache cache = this.rtNatPort.query(this.dir);
            boolean found = false;
            if (!cache.isResolved(this.natLink)) {
                if (!this.isPrepared) {
                    this.prepare();
                }
                CaptureResultSnapshot snapShot = this.apiNatCapture.ResultGet();
                long startSearchMoment = System.currentTimeMillis();
                long nextWait = 8L;
                found = false;
                do {
                    Wait.create(this.getContext(), nextWait, this.getDescription()).invoke();
                    snapShot.Refresh();
                    nextWait *= 2L;
                } while (!(found = this.processCapture(cache, this.probe)) && System.currentTimeMillis() < startSearchMoment + 1000L);
                this.apiNatCapture.Stop();
            }
            this.other = cache.result(this.natLink);
            NatDiscoveryParameters result = cache.parameters(this.natLink);
            if (this.other == null) {
                return;
            }
            try {
                ((Listener)this.getListener()).onNatPortDiscovered(this.rtExternPort, this.rtNatPort, this.other.getSource(), this.other.protocol(), this.natLink.getPort(), this.other.getPort(), result);
            }
            catch (RuntimeInitializationError e) {
                ((Listener)this.getListener()).onNatPortDiscoveryFailed(this.rtExternPort, this.rtNatPort, this.natLink.protocol(), this.natLink.getPort(), e.getMessage());
                throw e;
            }
        }
        finally {
            this.cleanupNatDiscoveryFlow();
        }
    }

    private void createNatDiscoveryFlow(LinkProbe probe, String filter) {
        EthernetPacket packetEthernet = probe.getPacket();
        this.apiNatStream = this.rtNatPort.createNATStream(packetEthernet, 100000000L);
        ByteBlowerPort apiNatDstPort = this.rtExternPort.getApiPort();
        this.apiNatCapture = apiNatDstPort.RxCaptureBasicAdd();
        this.apiNatCapture.FilterSet(filter);
    }

    private boolean processCapture(NATCache cache, LinkProbe probe) {
        CapturedFrameList frameList = this.apiNatCapture.ResultGet().FramesGet();
        boolean found = false;
        for (CapturedFrame capturedNatDiscoveryFrame : frameList) {
            Buffer captureBuffer = capturedNatDiscoveryFrame.BufferGet();
            byte[] ethFrameBuffer = new byte[captureBuffer.size()];
            int ctr = 0;
            while (ctr < ethFrameBuffer.length) {
                ethFrameBuffer[ctr] = captureBuffer.get(ctr).byteValue();
                ++ctr;
            }
            found = cache.resolve(this.natLink, probe, ethFrameBuffer);
            if (!found) continue;
            this.other = cache.result(this.natLink);
            break;
        }
        return found;
    }

    private void cleanupNatDiscoveryFlow() {
        try {
            if (this.apiNatCapture != null) {
                this.rtExternPort.getApiPort().RxCaptureBasicRemove(this.apiNatCapture);
            }
        }
        catch (Exception e) {
            LOGGER.severe("Cleaning up NAT flow:" + e.getMessage());
        }
    }

    public static enum EndPointType {
        DESTINATION,
        SOURCE;

    }

    public static enum IpType {
        AUTOMATIC_PUBLIC_IP_DISCOVERY,
        MANUAL_PUBLIC_IP;

    }

    public static enum L4Protocol {
        TCP,
        UDP;

    }

    public static interface Listener {
        public void onNatDiscovered(RuntimePort var1, RuntimePort var2, String var3, NatDiscoveryParameters var4);

        public void onNatPortDiscovered(RuntimePort var1, RuntimePort var2, String var3, L4Protocol var4, Integer var5, Integer var6, NatDiscoveryParameters var7);

        public void onNatDiscoveryFailed(RuntimePort var1, RuntimePort var2, String var3);

        public void onNatPortDiscoveryFailed(RuntimePort var1, RuntimePort var2, L4Protocol var3, Integer var4, String var5);
    }

    public static class NatDiscoveryParameters {
        private final L4Protocol discoverProtocol;
        private final IpType ipType;
        private final PortType portType;

        public NatDiscoveryParameters(IpType ipType, PortType portType, L4Protocol discoverProtocol) {
            this.discoverProtocol = discoverProtocol;
            this.ipType = ipType;
            this.portType = portType;
        }

        public IpType getIpType() {
            return this.ipType;
        }

        public L4Protocol getDiscoverProtocol() {
            return this.discoverProtocol;
        }

        public PortType getPortType() {
            return this.portType;
        }
    }

    public static enum PortType {
        AUTOMATIC_PUBLIC_PORT_DISCOVERY,
        MANUAL_PUBLIC_PORT;

    }
}

