/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.DHCPFailed;
import com.excentis.products.byteblower.communication.api.DHCPv4Protocol;
import com.excentis.products.byteblower.communication.api.DHCPv6Protocol;
import com.excentis.products.byteblower.communication.api.IPv4Configuration;
import com.excentis.products.byteblower.communication.api.IPv6Configuration;
import com.excentis.products.byteblower.communication.api.RetransmissionPolicy;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.DhcpReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeIPv4Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeIPv6Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeLayer3Configuration;
import com.excentis.products.byteblower.run.objects.RuntimePort;

public final class PerformDhcp
extends ConcreteAction<Listener> {
    private final RuntimePort rtPort;
    private final RuntimeLayer3Configuration rtL3Config;
    private final ByteBlowerGuiPortReader mPortReader;

    static AbstractAction create(Context context, RuntimeLayer3Configuration rtL3Config) {
        return context.decorate(new PerformDhcp(context, rtL3Config));
    }

    private PerformDhcp(Context context, RuntimeLayer3Configuration rtL3Config) {
        super(context, Listener.class);
        this.rtL3Config = rtL3Config;
        this.rtPort = rtL3Config.getRuntimePort();
        this.mPortReader = this.rtPort.getModelPortReader();
    }

    @Override
    public String getDescription() {
        return "Perform DHCP on '" + this.rtPort.getName() + "'";
    }

    @Override
    public void invokeImpl() {
        if (this.mPortReader.isIPv4()) {
            try {
                this.performDHCPv4();
            }
            catch (DHCPFailed e) {
                RuntimePort port = this.rtL3Config.getRuntimePort();
                String msgFmt = "%s\n   Interface: '%s'\n   Port: '%s'";
                String msg = String.format(msgFmt, e.getInfo(), port.getInterfaceName(), port.getName());
                ((Listener)this.getListener()).onDHCPPerformFailed(this.rtL3Config, msg);
                throw new DHCPFailed(msg);
            }
        } else if (this.mPortReader.isIPv6()) {
            try {
                this.performDHCPv6();
            }
            catch (DHCPFailed e) {
                RuntimePort port = this.rtL3Config.getRuntimePort();
                String msgFmt = "%s\n   Interface: '%s'\n   Port: '%s'";
                String msg = String.format(msgFmt, e.getInfo(), port.getInterfaceName(), port.getName());
                ((Listener)this.getListener()).onDHCPPerformFailed(this.rtL3Config, msg);
                throw new DHCPFailed(msg);
            }
        } else {
            throw new IllegalStateException("Unknown layer 3 type for DHCP on model port " + this.mPortReader.getName());
        }
    }

    private void performDHCPv4() {
        if (this.rtL3Config instanceof RuntimeIPv4Configuration) {
            RuntimeIPv4Configuration rtIpv4Config = (RuntimeIPv4Configuration)this.rtL3Config;
            IPv4Configuration apiIpv4Config = rtIpv4Config.getApiConfiguration();
            DHCPv4Protocol protocol = apiIpv4Config.ProtocolDhcpGet();
            System.out.format("Broadcast is %s %n", protocol.BroadcastFlagIsEnabled());
            if (this.rtL3Config.getRuntimePort().getState() == RuntimePort.State.CREATED) {
                this.useDhcpv4Options(this.mPortReader.getDhcpv4(), protocol);
                protocol.PerformAsync();
            } else if (this.rtL3Config.getRuntimePort().getState() == RuntimePort.State.CONFIGURED_AND_WAITING_FOR_ASYNC) {
                protocol.Perform();
                ((Listener)this.getListener()).onDHCPPerformed(this.rtL3Config);
            }
        } else {
            throw new IllegalStateException("rtL3Config should be be IPv4 at this point");
        }
    }

    private void performDHCPv6() {
        if (this.rtL3Config instanceof RuntimeIPv6Configuration) {
            RuntimeIPv6Configuration rtIpv6Config = (RuntimeIPv6Configuration)this.rtL3Config;
            IPv6Configuration apiIpv6Config = rtIpv6Config.getApiConfiguration();
            DHCPv6Protocol protocol = apiIpv6Config.ProtocolDhcpGet();
            if (this.rtL3Config.getRuntimePort().getState() == RuntimePort.State.CREATED) {
                this.useDhcpv6Options(this.mPortReader.getDhcpv6(), protocol);
                protocol.PerformAsync();
            } else if (this.rtL3Config.getRuntimePort().getState() == RuntimePort.State.CONFIGURED_AND_WAITING_FOR_ASYNC) {
                protocol.Perform();
                ((Listener)this.getListener()).onDHCPPerformed(this.rtL3Config);
            }
        } else {
            throw new IllegalStateException("rtL3Config should be be IPv6 at this point");
        }
    }

    private void useDhcpv4Options(Dhcp mDhcp, DHCPv4Protocol protocol) {
        DhcpReader mDhcpReader = ReaderFactory.create((Dhcp)mDhcp);
        protocol.DiscoverInitialTimeoutSet(mDhcpReader.getDiscoverTimeoutInNanos());
        protocol.DiscoverMaxRetriesSet(mDhcpReader.getMaximumDiscoverRetries());
        protocol.RequestInitialTimeoutSet(mDhcpReader.getRequestTimeoutInNanos());
        protocol.RequestMaxRetriesSet(mDhcpReader.getMaximumRequestRetries());
        protocol.RetransmissionPolicySet(this.getApiRetransmissionPolicy(mDhcpReader.getRetransmissionPolicy()));
    }

    private void useDhcpv6Options(Dhcp mDhcp, DHCPv6Protocol protocol) {
        DhcpReader mDhcpReader = ReaderFactory.create((Dhcp)mDhcp);
        protocol.SolicitInitialTimeoutSet(mDhcpReader.getDiscoverTimeoutInNanos());
        protocol.SolicitMaxRetriesSet(mDhcpReader.getMaximumDiscoverRetries());
        protocol.RequestInitialTimeoutSet(mDhcpReader.getRequestTimeoutInNanos());
        protocol.RequestMaxRetriesSet(mDhcpReader.getMaximumRequestRetries());
        protocol.RetransmissionPolicySet(this.getApiRetransmissionPolicy(mDhcpReader.getRetransmissionPolicy()));
    }

    private RetransmissionPolicy getApiRetransmissionPolicy(com.excentis.products.byteblower.model.RetransmissionPolicy mPolicy) {
        switch (mPolicy) {
            case FIXED_TIMING: {
                return RetransmissionPolicy.FixedTiming;
            }
        }
        return RetransmissionPolicy.RfcSuggested;
    }

    public static interface Listener {
        public void onDHCPPerformed(RuntimeLayer3Configuration var1);

        public void onDHCPPerformFailed(RuntimeLayer3Configuration var1, String var2);
    }
}

