/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.IPv6Configuration;
import com.excentis.products.byteblower.communication.api.InitializationError;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeIPv6Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeLayer3Configuration;
import com.excentis.products.byteblower.run.objects.RuntimePort;

public final class PerformStatelessAutoconfiguration
extends ConcreteAction<Listener> {
    private final RuntimePort rtPort;
    private final RuntimeLayer3Configuration rtL3Config;
    private final ByteBlowerGuiPortReader mPortReader;

    static AbstractAction create(Context context, RuntimeLayer3Configuration rtL3Config) {
        return context.decorate(new PerformStatelessAutoconfiguration(context, rtL3Config));
    }

    private PerformStatelessAutoconfiguration(Context context, RuntimeLayer3Configuration rtL3Config) {
        super(context, Listener.class);
        this.rtL3Config = rtL3Config;
        this.rtPort = rtL3Config.getRuntimePort();
        this.mPortReader = this.rtPort.getModelPortReader();
    }

    @Override
    public String getDescription() {
        return "Perform stateless autoconfiguration on '" + this.rtPort.getName() + "'";
    }

    @Override
    public void invokeImpl() {
        if (this.mPortReader.isIPv6()) {
            try {
                this.performSLAAC();
            }
            catch (InitializationError e) {
                ((Listener)this.getListener()).onStatelessAutoconfigurationFailed(this.rtL3Config, e.getMessage());
                throw e;
            }
        } else {
            throw new IllegalStateException("Unknown layer 3 type for SLAAC on model port " + this.mPortReader.getName());
        }
    }

    private void performSLAAC() {
        if (!(this.rtL3Config instanceof RuntimeIPv6Configuration)) {
            throw new IllegalStateException("rtL3Config should be be IPv6 at this point");
        }
        RuntimeIPv6Configuration rtIpv6Config = (RuntimeIPv6Configuration)this.rtL3Config;
        IPv6Configuration apiIpv6Config = rtIpv6Config.getApiConfiguration();
        apiIpv6Config.StatelessAutoconfiguration();
        ((Listener)this.getListener()).onStatelessAutoconfigurationPerformed(this.rtL3Config);
    }

    public static interface Listener {
        public void onStatelessAutoconfigurationPerformed(RuntimeLayer3Configuration var1);

        public void onStatelessAutoconfigurationFailed(RuntimeLayer3Configuration var1, String var2);
    }
}

